/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.createanewdeployforanorganization;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import com.nodepit.nodes.sentry.v0.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class CreateANewDeployForAnOrganizationNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String VERSION_KEY = "version";
    private static final String VERSION_DEFAULT_VALUE = null;
    private String version = VERSION_DEFAULT_VALUE;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateANewDeployForAnOrganizationNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"environment\":\"rows[0][0]\",\"name\":\"rows[0][1]\",\"dateStarted\":\"rows[0][2]\",\"dateFinished\":\"rows[0][3]\",\"url\":\"rows[0][4]\",\"id\":\"rows[0][5]\"}}]").addBodyColumn(new DataColumnSpecCreator("Environment", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Started", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Finished", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Url", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    CreateANewDeployForAnOrganizationNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(VERSION_KEY, this.version);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.version = settings.getString(VERSION_KEY, VERSION_DEFAULT_VALUE);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.version == null || this.version.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cVersion\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String version() {
        return this.version;
    }

    void version(String value) {
        this.version = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

