/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.createanewproject;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import com.nodepit.nodes.sentry.v0.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class CreateANewProjectNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String TEAM_ID_OR_SLUG_KEY = "teamIdOrSlug";
    private static final String TEAM_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String teamIdOrSlug = TEAM_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateANewProjectNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"stats\":\"rows[0][0]\",\"transactionStats\":\"rows[0][1]\",\"sessionStats\":\"rows[0][2]\",\"id\":\"rows[0][3]\",\"slug\":\"rows[0][4]\",\"name\":\"rows[0][5]\",\"platform\":\"rows[0][6]\",\"dateCreated\":\"rows[0][7]\",\"isBookmarked\":\"rows[0][8]\",\"isMember\":\"rows[0][9]\",\"features\":\"rows[0][10]\",\"firstEvent\":\"rows[0][11]\",\"firstTransactionEvent\":\"rows[0][12]\",\"access\":\"rows[0][13]\",\"hasAccess\":\"rows[0][14]\",\"hasCustomMetrics\":\"rows[0][15]\",\"hasMinifiedStackTrace\":\"rows[0][16]\",\"hasMonitors\":\"rows[0][17]\",\"hasProfiles\":\"rows[0][18]\",\"hasReplays\":\"rows[0][19]\",\"hasSessions\":\"rows[0][20]\",\"hasInsightsHttp\":\"rows[0][21]\",\"hasInsightsDb\":\"rows[0][22]\",\"hasInsightsAssets\":\"rows[0][23]\",\"hasInsightsAppStart\":\"rows[0][24]\",\"hasInsightsScreenLoad\":\"rows[0][25]\",\"hasInsightsVitals\":\"rows[0][26]\",\"hasInsightsCaches\":\"rows[0][27]\",\"hasInsightsQueues\":\"rows[0][28]\",\"hasInsightsLlmMonitoring\":\"rows[0][29]\",\"isInternal\":\"rows[0][30]\",\"isPublic\":\"rows[0][31]\",\"avatar\":\"rows[0][32]\",\"color\":\"rows[0][33]\",\"status\":\"rows[0][34]\"}}]").addBodyColumn(new DataColumnSpecCreator("Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Transaction Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Session Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Platform", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Bookmarked", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Member", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Features", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Event", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Transaction Event", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Access", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Access", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Custom Metrics", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Minified Stack Trace", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Monitors", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Profiles", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Replays", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Sessions", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Http", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Db", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Assets", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights App Start", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Screen Load", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Vitals", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Caches", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Queues", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Llm Monitoring", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Internal", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Public", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Avatar", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Color", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    CreateANewProjectNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(TEAM_ID_OR_SLUG_KEY, this.teamIdOrSlug);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.teamIdOrSlug = settings.getString(TEAM_ID_OR_SLUG_KEY, TEAM_ID_OR_SLUG_DEFAULT_VALUE);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.teamIdOrSlug == null || this.teamIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTeam Id or Slug\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String teamIdOrSlug() {
        return this.teamIdOrSlug;
    }

    void teamIdOrSlug(String value) {
        this.teamIdOrSlug = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

