/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.listanissueshashes;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ListAnIssuesHashesNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String ISSUE_ID_KEY = "issueId";
    private static final String ISSUE_ID_DEFAULT_VALUE = null;
    private String issueId = ISSUE_ID_DEFAULT_VALUE;
    private static final String CURSOR_KEY = "cursor";
    private static final String CURSOR_DEFAULT_VALUE = null;
    private String cursor = CURSOR_DEFAULT_VALUE;
    private static final String CURSOR_ENABLED_KEY = "cursorEnabled";
    private boolean cursorEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"latestEvent\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Latest Event", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ListAnIssuesHashesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(ISSUE_ID_KEY, this.issueId);
        settings.addString(CURSOR_KEY, this.cursor);
        settings.addBoolean(CURSOR_ENABLED_KEY, this.cursorEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.issueId = settings.getString(ISSUE_ID_KEY, ISSUE_ID_DEFAULT_VALUE);
        this.cursor = settings.getString(CURSOR_KEY, CURSOR_DEFAULT_VALUE);
        this.cursorEnabled = settings.getBoolean(CURSOR_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.issueId == null || this.issueId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cIssue Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String issueId() {
        return this.issueId;
    }

    void issueId(String value) {
        this.issueId = value;
    }

    String cursor() {
        return this.cursor;
    }

    void cursor(String value) {
        this.cursor = value;
    }

    boolean cursorEnabled() {
        return this.cursorEnabled;
    }

    void cursorEnabled(boolean value) {
        this.cursorEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

