/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.retrieveaproject;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class RetrieveAProjectNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String PROJECT_ID_OR_SLUG_KEY = "projectIdOrSlug";
    private static final String PROJECT_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String projectIdOrSlug = PROJECT_ID_OR_SLUG_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"stats\":\"rows[0][0]\",\"transactionStats\":\"rows[0][1]\",\"sessionStats\":\"rows[0][2]\",\"id\":\"rows[0][3]\",\"slug\":\"rows[0][4]\",\"name\":\"rows[0][5]\",\"platform\":\"rows[0][6]\",\"dateCreated\":\"rows[0][7]\",\"isBookmarked\":\"rows[0][8]\",\"isMember\":\"rows[0][9]\",\"features\":\"rows[0][10]\",\"firstEvent\":\"rows[0][11]\",\"firstTransactionEvent\":\"rows[0][12]\",\"access\":\"rows[0][13]\",\"hasAccess\":\"rows[0][14]\",\"hasCustomMetrics\":\"rows[0][15]\",\"hasMinifiedStackTrace\":\"rows[0][16]\",\"hasMonitors\":\"rows[0][17]\",\"hasProfiles\":\"rows[0][18]\",\"hasReplays\":\"rows[0][19]\",\"hasSessions\":\"rows[0][20]\",\"hasInsightsHttp\":\"rows[0][21]\",\"hasInsightsDb\":\"rows[0][22]\",\"hasInsightsAssets\":\"rows[0][23]\",\"hasInsightsAppStart\":\"rows[0][24]\",\"hasInsightsScreenLoad\":\"rows[0][25]\",\"hasInsightsVitals\":\"rows[0][26]\",\"hasInsightsCaches\":\"rows[0][27]\",\"hasInsightsQueues\":\"rows[0][28]\",\"hasInsightsLlmMonitoring\":\"rows[0][29]\",\"isInternal\":\"rows[0][30]\",\"isPublic\":\"rows[0][31]\",\"avatar\":\"rows[0][32]\",\"color\":\"rows[0][33]\",\"status\":\"rows[0][34]\",\"team\":\"rows[0][35]\",\"teams\":\"rows[0][36]\",\"latestRelease\":\"rows[0][37]\",\"options\":\"rows[0][38]\",\"digestsMinDelay\":\"rows[0][39]\",\"digestsMaxDelay\":\"rows[0][40]\",\"subjectPrefix\":\"rows[0][41]\",\"allowedDomains\":\"rows[0][42]\",\"resolveAge\":\"rows[0][43]\",\"dataScrubber\":\"rows[0][44]\",\"dataScrubberDefaults\":\"rows[0][45]\",\"safeFields\":\"rows[0][46]\",\"storeCrashReports\":\"rows[0][47]\",\"sensitiveFields\":\"rows[0][48]\",\"subjectTemplate\":\"rows[0][49]\",\"securityToken\":\"rows[0][50]\",\"securityTokenHeader\":\"rows[0][51]\",\"verifySSL\":\"rows[0][52]\",\"scrubIPAddresses\":\"rows[0][53]\",\"scrapeJavaScript\":\"rows[0][54]\",\"groupingConfig\":\"rows[0][55]\",\"groupingEnhancements\":\"rows[0][56]\",\"groupingEnhancementsBase\":\"rows[0][57]\",\"secondaryGroupingExpiry\":\"rows[0][58]\",\"secondaryGroupingConfig\":\"rows[0][59]\",\"groupingAutoUpdate\":\"rows[0][60]\",\"fingerprintingRules\":\"rows[0][61]\",\"organization\":\"rows[0][62]\",\"plugins\":\"rows[0][63]\",\"platforms\":\"rows[0][64]\",\"processingIssues\":\"rows[0][65]\",\"defaultEnvironment\":\"rows[0][66]\",\"relayPiiConfig\":\"rows[0][67]\",\"builtinSymbolSources\":\"rows[0][68]\",\"dynamicSamplingBiases\":\"rows[0][69]\",\"eventProcessing\":\"rows[0][70]\",\"symbolSources\":\"rows[0][71]\",\"extrapolateMetrics\":\"rows[0][72]\"}}]").addBodyColumn(new DataColumnSpecCreator("Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Transaction Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Session Stats", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Platform", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Bookmarked", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Member", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Features", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Event", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Transaction Event", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Access", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Access", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Custom Metrics", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Minified Stack Trace", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Monitors", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Profiles", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Replays", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Sessions", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Http", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Db", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Assets", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights App Start", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Screen Load", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Vitals", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Caches", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Queues", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Insights Llm Monitoring", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Internal", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Public", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Avatar", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Color", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Team", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Teams", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Latest Release", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Options", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Digests Min Delay", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Digests Max Delay", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Subject Prefix", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Allowed Domains", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Resolve Age", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data Scrubber", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data Scrubber Defaults", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Safe Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Store Crash Reports", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Sensitive Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Subject Template", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Security Token", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Security Token Header", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Verify SSL", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Scrub IP Addresses", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Scrape Java Script", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Grouping Config", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Grouping Enhancements", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Grouping Enhancements Base", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Secondary Grouping Expiry", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Secondary Grouping Config", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Grouping Auto Update", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fingerprinting Rules", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Organization", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Plugins", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Platforms", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Processing Issues", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Default Environment", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relay Pii Config", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Builtin Symbol Sources", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Dynamic Sampling Biases", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Event Processing", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Symbol Sources", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Extrapolate Metrics", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    RetrieveAProjectNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(PROJECT_ID_OR_SLUG_KEY, this.projectIdOrSlug);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.projectIdOrSlug = settings.getString(PROJECT_ID_OR_SLUG_KEY, PROJECT_ID_OR_SLUG_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.projectIdOrSlug == null || this.projectIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cProject Id or Slug\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String projectIdOrSlug() {
        return this.projectIdOrSlug;
    }

    void projectIdOrSlug(String value) {
        this.projectIdOrSlug = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

