/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthParametersMissingException;
import com.github.scribejava.core.extractors.BaseStringExtractor;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;

public class BaseStringExtractorImpl
implements BaseStringExtractor {
    protected static final String AMPERSAND_SEPARATED_STRING = "%s&%s&%s";

    @Override
    public String extract(OAuthRequest request) {
        this.checkPreconditions(request);
        String verb = OAuthEncoder.encode(this.getVerb(request));
        String url = OAuthEncoder.encode(this.getUrl(request));
        String params = this.getSortedAndEncodedParams(request);
        return String.format(AMPERSAND_SEPARATED_STRING, verb, url, params);
    }

    protected String getVerb(OAuthRequest request) {
        return request.getVerb().name();
    }

    protected String getUrl(OAuthRequest request) {
        return request.getSanitizedUrl();
    }

    protected String getSortedAndEncodedParams(OAuthRequest request) {
        ParameterList params = new ParameterList();
        params.addAll(request.getQueryStringParams());
        params.addAll(request.getBodyParams());
        params.addAll(new ParameterList(request.getOauthParameters()));
        return params.sort().asOauthBaseString();
    }

    protected void checkPreconditions(OAuthRequest request) {
        Preconditions.checkNotNull(request, "Cannot extract base string from a null object");
        if (request.getOauthParameters() == null || request.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(request);
        }
    }
}

