/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.createanewreleaseforanorganization;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import com.nodepit.nodes.sentry.v0.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class CreateANewReleaseForAnOrganizationNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateANewReleaseForAnOrganizationNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"authors\":\"rows[0][1]\",\"commitCount\":\"rows[0][2]\",\"data\":\"rows[0][3]\",\"dateCreated\":\"rows[0][4]\",\"dateReleased\":\"rows[0][5]\",\"deployCount\":\"rows[0][6]\",\"firstEvent\":\"rows[0][7]\",\"lastCommit\":\"rows[0][8]\",\"lastDeploy\":\"rows[0][9]\",\"lastEvent\":\"rows[0][10]\",\"newGroups\":\"rows[0][11]\",\"owner\":\"rows[0][12]\",\"projects\":\"rows[0][13]\",\"ref\":\"rows[0][14]\",\"shortVersion\":\"rows[0][15]\",\"version\":\"rows[0][16]\",\"url\":\"rows[0][17]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Authors", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Commit Count", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Released", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deploy Count", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Event", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Commit", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Deploy", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Event", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("New Groups", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Owner", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Projects", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Ref", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Version", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Version", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Url", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    CreateANewReleaseForAnOrganizationNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

