/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.listanissuesevents;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ListAnIssuesEventsNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String ISSUE_ID_KEY = "issueId";
    private static final String ISSUE_ID_DEFAULT_VALUE = null;
    private String issueId = ISSUE_ID_DEFAULT_VALUE;
    private static final String FULL_KEY = "full";
    private static final boolean FULL_DEFAULT_VALUE = false;
    private boolean full = false;
    private static final String FULL_ENABLED_KEY = "fullEnabled";
    private boolean fullEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"eventID\":\"rows[#2][0]\",\"tags\":\"rows[#2][1]\",\"dateCreated\":\"rows[#2][2]\",\"user\":\"rows[#2][3]\",\"message\":\"rows[#2][4]\",\"id\":\"rows[#2][5]\",\"platform\":\"rows[#2][6]\",\"event.type\":\"rows[#2][7]\",\"groupID\":\"rows[#2][8]\",\"title\":\"rows[#2][9]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Event ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tags", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("User", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Message", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Platform", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Event.type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Group ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Title", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ListAnIssuesEventsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(ISSUE_ID_KEY, this.issueId);
        settings.addBoolean(FULL_KEY, this.full);
        settings.addBoolean(FULL_ENABLED_KEY, this.fullEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.issueId = settings.getString(ISSUE_ID_KEY, ISSUE_ID_DEFAULT_VALUE);
        this.full = settings.getBoolean(FULL_KEY, false);
        this.fullEnabled = settings.getBoolean(FULL_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.issueId == null || this.issueId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cIssue Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String issueId() {
        return this.issueId;
    }

    void issueId(String value) {
        this.issueId = value;
    }

    boolean full() {
        return this.full;
    }

    void full(boolean value) {
        this.full = value;
    }

    boolean fullEnabled() {
        return this.fullEnabled;
    }

    void fullEnabled(boolean value) {
        this.fullEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

