/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.listaprojectsissues;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ListAProjectsIssuesNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String PROJECT_ID_OR_SLUG_KEY = "projectIdOrSlug";
    private static final String PROJECT_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String projectIdOrSlug = PROJECT_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String STATS_PERIOD_KEY = "statsPeriod";
    private static final String STATS_PERIOD_DEFAULT_VALUE = null;
    private String statsPeriod = STATS_PERIOD_DEFAULT_VALUE;
    private static final String STATS_PERIOD_ENABLED_KEY = "statsPeriodEnabled";
    private boolean statsPeriodEnabled = false;
    private static final String SHORT_ID_LOOKUP_KEY = "shortIdLookup";
    private static final boolean SHORT_ID_LOOKUP_DEFAULT_VALUE = false;
    private boolean shortIdLookup = false;
    private static final String SHORT_ID_LOOKUP_ENABLED_KEY = "shortIdLookupEnabled";
    private boolean shortIdLookupEnabled = false;
    private static final String QUERY_KEY = "query";
    private static final String QUERY_DEFAULT_VALUE = null;
    private String query = QUERY_DEFAULT_VALUE;
    private static final String QUERY_ENABLED_KEY = "queryEnabled";
    private boolean queryEnabled = false;
    private static final String CURSOR_KEY = "cursor";
    private static final String CURSOR_DEFAULT_VALUE = null;
    private String cursor = CURSOR_DEFAULT_VALUE;
    private static final String CURSOR_ENABLED_KEY = "cursorEnabled";
    private boolean cursorEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"annotations\":\"rows[#2][0]\",\"assignedTo\":\"rows[#2][1]\",\"count\":\"rows[#2][2]\",\"culprit\":\"rows[#2][3]\",\"firstSeen\":\"rows[#2][4]\",\"hasSeen\":\"rows[#2][5]\",\"id\":\"rows[#2][6]\",\"isBookmarked\":\"rows[#2][7]\",\"isPublic\":\"rows[#2][8]\",\"isSubscribed\":\"rows[#2][9]\",\"lastSeen\":\"rows[#2][10]\",\"level\":\"rows[#2][11]\",\"logger\":\"rows[#2][12]\",\"metadata\":\"rows[#2][13]\",\"numComments\":\"rows[#2][14]\",\"permalink\":\"rows[#2][15]\",\"project\":\"rows[#2][16]\",\"shareId\":\"rows[#2][17]\",\"shortId\":\"rows[#2][18]\",\"stats\":\"rows[#2][19]\",\"status\":\"rows[#2][20]\",\"statusDetails\":\"rows[#2][21]\",\"subscriptionDetails\":\"rows[#2][22]\",\"title\":\"rows[#2][23]\",\"type\":\"rows[#2][24]\",\"userCount\":\"rows[#2][25]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Annotations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Assigned To", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Count", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Culprit", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Seen", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Seen", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Bookmarked", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Public", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Subscribed", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Seen", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Level", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Logger", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metadata", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Num Comments", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Permalink", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Project", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Share Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Stats", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status Details", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Subscription Details", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Title", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("User Count", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ListAProjectsIssuesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(PROJECT_ID_OR_SLUG_KEY, this.projectIdOrSlug);
        settings.addString(STATS_PERIOD_KEY, this.statsPeriod);
        settings.addBoolean(STATS_PERIOD_ENABLED_KEY, this.statsPeriodEnabled);
        settings.addBoolean(SHORT_ID_LOOKUP_KEY, this.shortIdLookup);
        settings.addBoolean(SHORT_ID_LOOKUP_ENABLED_KEY, this.shortIdLookupEnabled);
        settings.addString(QUERY_KEY, this.query);
        settings.addBoolean(QUERY_ENABLED_KEY, this.queryEnabled);
        settings.addString(CURSOR_KEY, this.cursor);
        settings.addBoolean(CURSOR_ENABLED_KEY, this.cursorEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.projectIdOrSlug = settings.getString(PROJECT_ID_OR_SLUG_KEY, PROJECT_ID_OR_SLUG_DEFAULT_VALUE);
        this.statsPeriod = settings.getString(STATS_PERIOD_KEY, STATS_PERIOD_DEFAULT_VALUE);
        this.statsPeriodEnabled = settings.getBoolean(STATS_PERIOD_ENABLED_KEY, false);
        this.shortIdLookup = settings.getBoolean(SHORT_ID_LOOKUP_KEY, false);
        this.shortIdLookupEnabled = settings.getBoolean(SHORT_ID_LOOKUP_ENABLED_KEY, false);
        this.query = settings.getString(QUERY_KEY, QUERY_DEFAULT_VALUE);
        this.queryEnabled = settings.getBoolean(QUERY_ENABLED_KEY, false);
        this.cursor = settings.getString(CURSOR_KEY, CURSOR_DEFAULT_VALUE);
        this.cursorEnabled = settings.getBoolean(CURSOR_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.projectIdOrSlug == null || this.projectIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cProject Id or Slug\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String projectIdOrSlug() {
        return this.projectIdOrSlug;
    }

    void projectIdOrSlug(String value) {
        this.projectIdOrSlug = value;
    }

    String statsPeriod() {
        return this.statsPeriod;
    }

    void statsPeriod(String value) {
        this.statsPeriod = value;
    }

    boolean statsPeriodEnabled() {
        return this.statsPeriodEnabled;
    }

    void statsPeriodEnabled(boolean value) {
        this.statsPeriodEnabled = value;
    }

    boolean shortIdLookup() {
        return this.shortIdLookup;
    }

    void shortIdLookup(boolean value) {
        this.shortIdLookup = value;
    }

    boolean shortIdLookupEnabled() {
        return this.shortIdLookupEnabled;
    }

    void shortIdLookupEnabled(boolean value) {
        this.shortIdLookupEnabled = value;
    }

    String query() {
        return this.query;
    }

    void query(String value) {
        this.query = value;
    }

    boolean queryEnabled() {
        return this.queryEnabled;
    }

    void queryEnabled(boolean value) {
        this.queryEnabled = value;
    }

    String cursor() {
        return this.cursor;
    }

    void cursor(String value) {
        this.cursor = value;
    }

    boolean cursorEnabled() {
        return this.cursorEnabled;
    }

    void cursorEnabled(boolean value) {
        this.cursorEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

