/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.listyourprojects;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ListYourProjectsNodeSettings {
    private static final String CURSOR_KEY = "cursor";
    private static final String CURSOR_DEFAULT_VALUE = null;
    private String cursor = CURSOR_DEFAULT_VALUE;
    private static final String CURSOR_ENABLED_KEY = "cursorEnabled";
    private boolean cursorEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"avatar\":\"rows[#2][0]\",\"color\":\"rows[#2][1]\",\"dateCreated\":\"rows[#2][2]\",\"features\":\"rows[#2][3]\",\"firstEvent\":\"rows[#2][4]\",\"hasAccess\":\"rows[#2][5]\",\"id\":\"rows[#2][6]\",\"isBookmarked\":\"rows[#2][7]\",\"isInternal\":\"rows[#2][8]\",\"isMember\":\"rows[#2][9]\",\"isPublic\":\"rows[#2][10]\",\"name\":\"rows[#2][11]\",\"organization\":\"rows[#2][12]\",\"platform\":\"rows[#2][13]\",\"slug\":\"rows[#2][14]\",\"status\":\"rows[#2][15]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Avatar", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Color", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Features", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Event", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has Access", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Bookmarked", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Internal", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Member", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Public", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Organization", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Platform", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ListYourProjectsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(CURSOR_KEY, this.cursor);
        settings.addBoolean(CURSOR_ENABLED_KEY, this.cursorEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.cursor = settings.getString(CURSOR_KEY, CURSOR_DEFAULT_VALUE);
        this.cursorEnabled = settings.getBoolean(CURSOR_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String cursor() {
        return this.cursor;
    }

    void cursor(String value) {
        this.cursor = value;
    }

    boolean cursorEnabled() {
        return this.cursorEnabled;
    }

    void cursorEnabled(boolean value) {
        this.cursorEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

