/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.retrieveeventcountsforateam;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class RetrieveEventCountsForATeamNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String TEAM_ID_OR_SLUG_KEY = "teamIdOrSlug";
    private static final String TEAM_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String teamIdOrSlug = TEAM_ID_OR_SLUG_DEFAULT_VALUE;
    static final String[] STAT_VALUES = new String[]{"received", "rejected"};
    private static final String STAT_KEY = "stat";
    private static final String STAT_DEFAULT_VALUE = STAT_VALUES[0];
    private String stat = STAT_DEFAULT_VALUE;
    private static final String STAT_ENABLED_KEY = "statEnabled";
    private boolean statEnabled = false;
    private static final String SINCE_KEY = "since";
    private static final String SINCE_DEFAULT_VALUE = null;
    private String since = SINCE_DEFAULT_VALUE;
    private static final String SINCE_ENABLED_KEY = "sinceEnabled";
    private boolean sinceEnabled = false;
    private static final String UNTIL_KEY = "until";
    private static final String UNTIL_DEFAULT_VALUE = null;
    private String until = UNTIL_DEFAULT_VALUE;
    private static final String UNTIL_ENABLED_KEY = "untilEnabled";
    private boolean untilEnabled = false;
    static final String[] RESOLUTION_VALUES = new String[]{"10s", "1h", "1d"};
    private static final String RESOLUTION_KEY = "resolution";
    private static final String RESOLUTION_DEFAULT_VALUE = RESOLUTION_VALUES[0];
    private String resolution = RESOLUTION_DEFAULT_VALUE;
    private static final String RESOLUTION_ENABLED_KEY = "resolutionEnabled";
    private boolean resolutionEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    RetrieveEventCountsForATeamNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(TEAM_ID_OR_SLUG_KEY, this.teamIdOrSlug);
        settings.addString(STAT_KEY, this.stat);
        settings.addBoolean(STAT_ENABLED_KEY, this.statEnabled);
        settings.addString(SINCE_KEY, this.since);
        settings.addBoolean(SINCE_ENABLED_KEY, this.sinceEnabled);
        settings.addString(UNTIL_KEY, this.until);
        settings.addBoolean(UNTIL_ENABLED_KEY, this.untilEnabled);
        settings.addString(RESOLUTION_KEY, this.resolution);
        settings.addBoolean(RESOLUTION_ENABLED_KEY, this.resolutionEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.teamIdOrSlug = settings.getString(TEAM_ID_OR_SLUG_KEY, TEAM_ID_OR_SLUG_DEFAULT_VALUE);
        this.stat = settings.getString(STAT_KEY, STAT_DEFAULT_VALUE);
        this.statEnabled = settings.getBoolean(STAT_ENABLED_KEY, false);
        this.since = settings.getString(SINCE_KEY, SINCE_DEFAULT_VALUE);
        this.sinceEnabled = settings.getBoolean(SINCE_ENABLED_KEY, false);
        this.until = settings.getString(UNTIL_KEY, UNTIL_DEFAULT_VALUE);
        this.untilEnabled = settings.getBoolean(UNTIL_ENABLED_KEY, false);
        this.resolution = settings.getString(RESOLUTION_KEY, RESOLUTION_DEFAULT_VALUE);
        this.resolutionEnabled = settings.getBoolean(RESOLUTION_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.teamIdOrSlug == null || this.teamIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTeam Id or Slug\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String teamIdOrSlug() {
        return this.teamIdOrSlug;
    }

    void teamIdOrSlug(String value) {
        this.teamIdOrSlug = value;
    }

    String stat() {
        return this.stat;
    }

    void stat(String value) {
        this.stat = value;
    }

    boolean statEnabled() {
        return this.statEnabled;
    }

    void statEnabled(boolean value) {
        this.statEnabled = value;
    }

    String since() {
        return this.since;
    }

    void since(String value) {
        this.since = value;
    }

    boolean sinceEnabled() {
        return this.sinceEnabled;
    }

    void sinceEnabled(boolean value) {
        this.sinceEnabled = value;
    }

    String until() {
        return this.until;
    }

    void until(String value) {
        this.until = value;
    }

    boolean untilEnabled() {
        return this.untilEnabled;
    }

    void untilEnabled(boolean value) {
        this.untilEnabled = value;
    }

    String resolution() {
        return this.resolution;
    }

    void resolution(String value) {
        this.resolution = value;
    }

    boolean resolutionEnabled() {
        return this.resolutionEnabled;
    }

    void resolutionEnabled(boolean value) {
        this.resolutionEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

