/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.updateanorganization;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import com.nodepit.nodes.sentry.v0.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class UpdateAnOrganizationNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", UpdateAnOrganizationNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    private static final String BODY_ENABLED_KEY = "bodyEnabled";
    private boolean bodyEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"access\":\"rows[0][0]\",\"allowSharedIssues\":\"rows[0][1]\",\"availableRoles\":\"rows[0][2]\",\"avatar\":\"rows[0][3]\",\"dataScrubber\":\"rows[0][4]\",\"dataScrubberDefaults\":\"rows[0][5]\",\"dateCreated\":\"rows[0][6]\",\"defaultRole\":\"rows[0][7]\",\"enhancedPrivacy\":\"rows[0][8]\",\"experiments\":\"rows[0][9]\",\"features\":\"rows[0][10]\",\"id\":\"rows[0][11]\",\"isDefault\":\"rows[0][12]\",\"isEarlyAdopter\":\"rows[0][13]\",\"name\":\"rows[0][14]\",\"onboardingTasks\":\"rows[0][15]\",\"openMembership\":\"rows[0][16]\",\"pendingAccessRequests\":\"rows[0][17]\",\"projects\":\"rows[0][18]\",\"quota\":\"rows[0][19]\",\"require2FA\":\"rows[0][20]\",\"safeFields\":\"rows[0][21]\",\"scrapeJavaScript\":\"rows[0][22]\",\"scrubIPAddresses\":\"rows[0][23]\",\"sensitiveFields\":\"rows[0][24]\",\"slug\":\"rows[0][25]\",\"status\":\"rows[0][26]\",\"storeCrashReports\":\"rows[0][27]\",\"teams\":\"rows[0][28]\",\"trustedRelays\":\"rows[0][29]\"}}]").addBodyColumn(new DataColumnSpecCreator("Access", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Allow Shared Issues", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Available Roles", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Avatar", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data Scrubber", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data Scrubber Defaults", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Default Role", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Enhanced Privacy", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Experiments", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Features", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Default", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Early Adopter", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Onboarding Tasks", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Open Membership", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Pending Access Requests", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Projects", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Quota", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Require2fa", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Safe Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Scrape Java Script", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Scrub IP Addresses", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Sensitive Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Slug", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Store Crash Reports", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Teams", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Trusted Relays", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    UpdateAnOrganizationNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(BODY_KEY, this.body);
        settings.addBoolean(BODY_ENABLED_KEY, this.bodyEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.bodyEnabled = settings.getBoolean(BODY_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    boolean bodyEnabled() {
        return this.bodyEnabled;
    }

    void bodyEnabled(boolean value) {
        this.bodyEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

