/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.sentry.v0.operation.updateanorganizationsrelease;

import com.nodepit.nodes.sentry.v0.ResponseMapper;
import com.nodepit.nodes.sentry.v0.SimpleResponseMapper;
import com.nodepit.nodes.sentry.v0.TransformToTableMapper;
import com.nodepit.nodes.sentry.v0.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class UpdateAnOrganizationsReleaseNodeSettings {
    private static final String ORGANIZATION_ID_OR_SLUG_KEY = "organizationIdOrSlug";
    private static final String ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE = null;
    private String organizationIdOrSlug = ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE;
    private static final String VERSION_KEY = "version";
    private static final String VERSION_DEFAULT_VALUE = null;
    private String version = VERSION_DEFAULT_VALUE;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", UpdateAnOrganizationsReleaseNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"ref\":\"rows[0][0]\",\"url\":\"rows[0][1]\",\"dateReleased\":\"rows[0][2]\",\"dateCreated\":\"rows[0][3]\",\"dateStarted\":\"rows[0][4]\",\"owner\":\"rows[0][5]\",\"lastCommit\":\"rows[0][6]\",\"lastDeploy\":\"rows[0][7]\",\"firstEvent\":\"rows[0][8]\",\"lastEvent\":\"rows[0][9]\",\"currentProjectMeta\":\"rows[0][10]\",\"userAgent\":\"rows[0][11]\",\"adoptionStages\":\"rows[0][12]\",\"id\":\"rows[0][13]\",\"version\":\"rows[0][14]\",\"newGroups\":\"rows[0][15]\",\"status\":\"rows[0][16]\",\"shortVersion\":\"rows[0][17]\",\"versionInfo\":\"rows[0][18]\",\"data\":\"rows[0][19]\",\"commitCount\":\"rows[0][20]\",\"deployCount\":\"rows[0][21]\",\"authors\":\"rows[0][22]\",\"projects\":\"rows[0][23]\"}}]").addBodyColumn(new DataColumnSpecCreator("Ref", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Url", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Released", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Created", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Date Started", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Owner", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Commit", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Deploy", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Event", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Event", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Current Project Meta", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("User Agent", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Adoption Stages", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Version", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("New Groups", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Short Version", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Version Info", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Commit Count", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deploy Count", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Authors", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Projects", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    UpdateAnOrganizationsReleaseNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ORGANIZATION_ID_OR_SLUG_KEY, this.organizationIdOrSlug);
        settings.addString(VERSION_KEY, this.version);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.organizationIdOrSlug = settings.getString(ORGANIZATION_ID_OR_SLUG_KEY, ORGANIZATION_ID_OR_SLUG_DEFAULT_VALUE);
        this.version = settings.getString(VERSION_KEY, VERSION_DEFAULT_VALUE);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.organizationIdOrSlug == null || this.organizationIdOrSlug.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOrganization Id or Slug\u201d is required.");
        }
        if (this.version == null || this.version.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cVersion\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String organizationIdOrSlug() {
        return this.organizationIdOrSlug;
    }

    void organizationIdOrSlug(String value) {
        this.organizationIdOrSlug = value;
    }

    String version() {
        return this.version;
    }

    void version(String value) {
        this.version = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

