/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.spellchecker;

import de.philippkatz.knime.spellchecker.SpellCheckerNodeDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortType;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.spelling.SpellingCheckRule;

public abstract class AbstractSpellCheckerNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(AbstractSpellCheckerNodeModel.class);
    protected final SettingsModelString settingInputColumn = SpellCheckerNodeDialog.createInputColumnModel();
    protected final SettingsModelString settingLanguage = SpellCheckerNodeDialog.createSelectedLanguageModel();
    protected final SettingsModelString settingNGramDirectory = SpellCheckerNodeDialog.createNGramDirectoryModel();
    private List<String> acceptPhrases;
    private Language language;

    protected AbstractSpellCheckerNodeModel() {
        super(new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE_OPTIONAL}, new PortType[]{BufferedDataTable.TYPE});
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        ArrayList<String> acceptPhrases = new ArrayList<String>();
        if (inData[1] != null) {
            for (DataRow row : inData[1]) {
                DataCell cell = row.getCell(0);
                if (cell.isMissing()) continue;
                String phrase = ((StringValue)cell).getStringValue();
                acceptPhrases.add(phrase);
            }
            LOGGER.infoWithFormat("Read %s 'accept phrases'", new Object[]{acceptPhrases.size()});
        }
        this.acceptPhrases = Collections.unmodifiableList(acceptPhrases);
        BufferedDataTable outTable = this.execute(inData[0], exec);
        return new BufferedDataTable[]{outTable};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        if (inSpecs[1] != null) {
            if (inSpecs[1].getNumColumns() != 1) {
                throw new InvalidSettingsException("Second table must have exactly one column.");
            }
            if (!inSpecs[1].getColumnSpec(0).getType().isCompatible(StringValue.class)) {
                throw new InvalidSettingsException("Second table's column type must be String.");
            }
        }
        if (inSpecs[0].findColumnIndex(this.settingInputColumn.getStringValue()) == -1) {
            throw new InvalidSettingsException("The table contains no such column '" + this.settingInputColumn.getStringValue() + "'.");
        }
        Language language = Languages.getLanguageForName((String)this.settingLanguage.getStringValue());
        if (language == null) {
            throw new InvalidSettingsException("No such language: " + this.settingLanguage.getStringValue());
        }
        return new DataTableSpec[]{this.createOutSpec(inSpecs[0])};
    }

    protected abstract BufferedDataTable execute(BufferedDataTable var1, ExecutionContext var2) throws Exception;

    protected abstract DataTableSpec createOutSpec(DataTableSpec var1) throws InvalidSettingsException;

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
        this.settingLanguage.saveSettingsTo(settings);
        this.settingNGramDirectory.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
        this.settingLanguage.validateSettings(settings);
        this.settingNGramDirectory.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
        this.settingLanguage.loadSettingsFrom(settings);
        this.settingNGramDirectory.loadSettingsFrom(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
        this.acceptPhrases = null;
        this.language = null;
    }

    private synchronized Language getLanguage() {
        if (this.language == null) {
            this.language = Languages.getLanguageForName((String)this.settingLanguage.getStringValue());
        }
        return this.language;
    }

    protected JLanguageTool newJLanguageTool() throws IOException {
        JLanguageTool jLanguageTool = new JLanguageTool(this.getLanguage());
        String nGramDirectory = this.settingNGramDirectory.getStringValue();
        if (nGramDirectory != null && !nGramDirectory.isEmpty()) {
            jLanguageTool.activateLanguageModelRules(new File(nGramDirectory));
        }
        if (this.acceptPhrases != null) {
            for (Rule rule : jLanguageTool.getAllActiveRules()) {
                if (!(rule instanceof SpellingCheckRule)) continue;
                ((SpellingCheckRule)rule).acceptPhrases(this.acceptPhrases);
            }
        }
        return jLanguageTool;
    }
}

