/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.spellchecker.rules.apply;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import de.philippkatz.knime.spellchecker.rules.apply.SpellCheckerApplyRuleNodeDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.DataValue;
import org.knime.core.data.IntValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.collection.ListDataValue;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.Tools;

public class SpellCheckerApplyRuleNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(SpellCheckerApplyRuleNodeModel.class);
    public static final int IN_TABLE_IDX_RULES = 0;
    public static final int IN_TABLE_IDX_TEXT = 1;
    private static final Rule DUMMY_RULE = new Rule(){

        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            return null;
        }

        public String getId() {
            return "DUMMY_RULE";
        }

        public String getDescription() {
            return null;
        }
    };
    private final SettingsModelString settingInputColumn = SpellCheckerApplyRuleNodeDialog.createInputColumnModel();

    protected SpellCheckerApplyRuleNodeModel() {
        super(2, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable ruleTable = inData[0];
        BufferedDataTable textTable = inData[1];
        PeekingIterator peekingRuleIterator = Iterators.peekingIterator((Iterator)ruleTable.iterator());
        int inputIndex = textTable.getSpec().findColumnIndex(this.settingInputColumn.getStringValue());
        long rowIndex = 0L;
        BufferedDataContainer container = exec.createDataContainer(this.createOutSpec(textTable.getDataTableSpec()));
        for (DataRow row : textTable) {
            DataCell appendedCell;
            String rowId = row.getKey().getString();
            DataCell inputCell = row.getCell(inputIndex);
            if (inputCell.isMissing()) {
                appendedCell = DataType.getMissingCell();
            } else {
                String inputString = ((StringValue)inputCell).getStringValue();
                List<RuleMatch> ruleMatches = SpellCheckerApplyRuleNodeModel.readAllRuleMatches((PeekingIterator<DataRow>)peekingRuleIterator, rowId);
                String correctedString = Tools.correctTextFromMatches((String)inputString, ruleMatches);
                appendedCell = new StringCell(correctedString);
            }
            container.addRowToTable((DataRow)new AppendedColumnRow(row, new DataCell[]{appendedCell}));
            exec.checkCanceled();
            exec.setProgress((double)rowIndex / (double)textTable.size(), "Processed row " + rowIndex + "/" + textTable.size() + " (\"" + String.valueOf(row.getKey()) + "\")");
            ++rowIndex;
        }
        container.close();
        return new BufferedDataTable[]{container.getTable()};
    }

    private static List<RuleMatch> readAllRuleMatches(PeekingIterator<DataRow> ruleRowIterator, String rowId) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        while (ruleRowIterator.hasNext()) {
            DataRow row = (DataRow)ruleRowIterator.peek();
            String inputRowId = ((StringValue)row.getCell(0)).getStringValue();
            if (!inputRowId.equals(rowId)) break;
            ruleRowIterator.next();
            int fromPosition = ((IntValue)row.getCell(1)).getIntValue();
            int toPosition = ((IntValue)row.getCell(2)).getIntValue();
            List<String> suggestedReplacements = StreamSupport.stream(((ListDataValue)row.getCell(4)).spliterator(), false).map(cell -> ((StringValue)cell).getStringValue()).collect(Collectors.toList());
            ruleMatches.add(new RuleMatch(DUMMY_RULE, fromPosition, toPosition, SpellCheckerApplyRuleNodeModel.createMessage(suggestedReplacements)));
        }
        LOGGER.debugWithFormat("Read %s rules for %s", new Object[]{ruleMatches.size(), rowId});
        return ruleMatches;
    }

    private static String createMessage(List<String> suggestions) {
        if (suggestions.isEmpty()) {
            return "";
        }
        return "<suggestion>" + String.join((CharSequence)"</suggestion><suggestion>", suggestions) + "</suggestion>";
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec ruleTableSpec = inSpecs[0];
        DataTableSpec textTableSpec = inSpecs[1];
        if (ruleTableSpec.getNumColumns() != 7) {
            throw new InvalidSettingsException("Expected a rule table with exactly seven columns.");
        }
        SpellCheckerApplyRuleNodeModel.verifyColumnType(ruleTableSpec, 0, StringValue.class);
        SpellCheckerApplyRuleNodeModel.verifyColumnType(ruleTableSpec, 1, IntValue.class);
        SpellCheckerApplyRuleNodeModel.verifyColumnType(ruleTableSpec, 2, IntValue.class);
        SpellCheckerApplyRuleNodeModel.verifyColumnType(ruleTableSpec, 3, StringValue.class);
        SpellCheckerApplyRuleNodeModel.verifyColumnType(ruleTableSpec, 4, ListDataValue.class);
        SpellCheckerApplyRuleNodeModel.verifyColumnType(ruleTableSpec, 5, StringValue.class);
        SpellCheckerApplyRuleNodeModel.verifyColumnType(ruleTableSpec, 6, StringValue.class);
        if (textTableSpec.findColumnIndex(this.settingInputColumn.getStringValue()) == -1) {
            throw new InvalidSettingsException("The text table contains no such column '" + this.settingInputColumn.getStringValue() + "'.");
        }
        DataTableSpec outSpec = this.createOutSpec(textTableSpec);
        return new DataTableSpec[]{outSpec};
    }

    private DataTableSpec createOutSpec(DataTableSpec textTableSpec) {
        String appendedColumnName = DataTableSpec.getUniqueColumnName((DataTableSpec)textTableSpec, (String)(this.settingInputColumn.getStringValue() + " (corrected)"));
        DataTableSpecCreator specCreator = new DataTableSpecCreator(textTableSpec);
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(appendedColumnName, StringCell.TYPE).createSpec()});
        return specCreator.createSpec();
    }

    private static void verifyColumnType(DataTableSpec spec, int index, Class<? extends DataValue> type) throws InvalidSettingsException {
        if (!spec.getColumnSpec(index).getType().isCompatible(type)) {
            throw new InvalidSettingsException("Column " + index + " must be of type String");
        }
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

