/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.spellchecker.rules.create;

import de.philippkatz.knime.spellchecker.AbstractSpellCheckerNodeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;

public class SpellCheckerRuleCreatorNodeModel
extends AbstractSpellCheckerNodeModel {
    @Override
    protected BufferedDataTable execute(BufferedDataTable textTable, ExecutionContext exec) throws Exception {
        int inputIndex = textTable.getDataTableSpec().findColumnIndex(this.settingInputColumn.getStringValue());
        long inRowIndex = 0L;
        long outRowIndex = 0L;
        BufferedDataContainer container = exec.createDataContainer(this.createOutSpec(textTable.getDataTableSpec()));
        JLanguageTool jLanguageTool = this.newJLanguageTool();
        for (DataRow row : textTable) {
            DataCell inputCell = row.getCell(inputIndex);
            if (inputCell.isMissing()) continue;
            String inputString = ((StringValue)inputCell).getStringValue();
            List ruleMatches = jLanguageTool.check(inputString);
            for (RuleMatch ruleMatch : ruleMatches) {
                ArrayList<Object> createdRow = new ArrayList<Object>();
                createdRow.add(new StringCell(row.getKey().getString()));
                createdRow.add(new IntCell(ruleMatch.getFromPos()));
                createdRow.add(new IntCell(ruleMatch.getToPos()));
                List suggestedReplacements = ruleMatch.getSuggestedReplacements().stream().map(StringCell::new).collect(Collectors.toList());
                createdRow.add(new StringCell(inputString.substring(ruleMatch.getFromPos(), ruleMatch.getToPos())));
                createdRow.add(CollectionCellFactory.createListCell(suggestedReplacements));
                createdRow.add(new StringCell(ruleMatch.getRule().getId()));
                createdRow.add(new StringCell(ruleMatch.getMessage()));
                container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)outRowIndex++), createdRow));
            }
            exec.checkCanceled();
            exec.setProgress((double)inRowIndex / (double)textTable.size(), "Processed row " + inRowIndex + "/" + textTable.size() + " (\"" + String.valueOf(row.getKey()) + "\")");
            ++inRowIndex;
        }
        container.close();
        return container.getTable();
    }

    @Override
    protected DataTableSpec createOutSpec(DataTableSpec textTableSpec) throws InvalidSettingsException {
        DataTableSpecCreator specCreator = new DataTableSpecCreator();
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Input Row ID", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("From Position", IntCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("To Position", IntCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Value", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Suggested Replacements", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Rule ID", StringCell.TYPE).createSpec()});
        specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Message", StringCell.TYPE).createSpec()});
        return specCreator.createSpec();
    }
}

