/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.spellchecker.simple;

import de.philippkatz.knime.spellchecker.AbstractSpellCheckerNodeModel;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.languagetool.JLanguageTool;
import org.languagetool.tools.Tools;

public class SpellCheckerNodeModel
extends AbstractSpellCheckerNodeModel {
    @Override
    protected BufferedDataTable execute(BufferedDataTable textTable, ExecutionContext exec) throws Exception {
        ColumnRearranger rearranger = this.createColumnRearranger(textTable.getDataTableSpec());
        return exec.createColumnRearrangeTable(textTable, rearranger, (ExecutionMonitor)exec);
    }

    @Override
    protected DataTableSpec createOutSpec(DataTableSpec textTableSpec) throws InvalidSettingsException {
        ColumnRearranger rearranger = this.createColumnRearranger(textTableSpec);
        return rearranger.createSpec();
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        String appendedColumnName = DataTableSpec.getUniqueColumnName((DataTableSpec)spec, (String)(this.settingInputColumn.getStringValue() + " (corrected)"));
        final int inputIndex = spec.findColumnIndex(this.settingInputColumn.getStringValue());
        SingleCellFactory cellFactory = new SingleCellFactory(true, new DataColumnSpecCreator(appendedColumnName, StringCell.TYPE).createSpec()){

            public DataCell getCell(DataRow row) {
                String correctedString;
                DataCell inputCell = row.getCell(inputIndex);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                String inputString = ((StringValue)inputCell).getStringValue();
                try {
                    JLanguageTool jLanguageTool = SpellCheckerNodeModel.this.newJLanguageTool();
                    correctedString = Tools.correctText((String)inputString, (JLanguageTool)jLanguageTool);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                return new StringCell(correctedString);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        return rearranger;
    }
}

