/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.spellchecker;

import org.knime.core.data.StringValue;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.languagetool.Languages;

public class SpellCheckerNodeDialog
extends DefaultNodeSettingsPane {
    private static final String CFGKEY_INPUT_COLUMN = "inputColumn";
    private static final String CFGKEY_SELECTED_LANGUAGE = "language";
    private static final String DEFAULT_LANGUAGE = "English (US)";
    private static final String NGRAM_DIRECTORY_HISTORY_ID = "de.philippkatz.knime.spellchecker.SpellCheckerNodeDialog.nGramDirectory";
    private static final String CFGKEY_NGRAM_DIRECTORY = "nGramDirectory";

    public SpellCheckerNodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(SpellCheckerNodeDialog.createInputColumnModel(), "Input", 0, new Class[]{StringValue.class}));
        String[] languageList = SpellCheckerNodeDialog.getLanguageList();
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(SpellCheckerNodeDialog.createSelectedLanguageModel(), "Language", languageList));
        this.createNewTab("N-gram Data");
        this.addDialogComponent((DialogComponent)new DialogComponentFileChooser(SpellCheckerNodeDialog.createNGramDirectoryModel(), NGRAM_DIRECTORY_HISTORY_ID, 0, true));
    }

    public static String[] getLanguageList() {
        return (String[])Languages.get().stream().filter(language -> !language.isHiddenFromGui()).map(language -> language.getName()).sorted().toArray(String[]::new);
    }

    public static SettingsModelString createInputColumnModel() {
        return new SettingsModelString(CFGKEY_INPUT_COLUMN, null);
    }

    public static SettingsModelString createSelectedLanguageModel() {
        return new SettingsModelString(CFGKEY_SELECTED_LANGUAGE, DEFAULT_LANGUAGE);
    }

    public static SettingsModelString createNGramDirectoryModel() {
        return new SettingsModelString(CFGKEY_NGRAM_DIRECTORY, null);
    }
}

