/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.knime.spellchecker.simple;

import de.philippkatz.knime.spellchecker.SpellCheckerNodeDialog;
import de.philippkatz.knime.spellchecker.simple.SpellCheckerNodeModel;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xmlbeans.XmlException;
import org.knime.core.node.DelegateNodeDescription;
import org.knime.core.node.NodeDescription;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeFactory;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SpellCheckerNodeFactory
extends NodeFactory<SpellCheckerNodeModel> {
    public SpellCheckerNodeModel createNodeModel() {
        return new SpellCheckerNodeModel();
    }

    protected int getNrNodeViews() {
        return 0;
    }

    public NodeView<SpellCheckerNodeModel> createNodeView(int viewIndex, SpellCheckerNodeModel nodeModel) {
        throw new UnsupportedOperationException();
    }

    protected boolean hasDialog() {
        return true;
    }

    protected NodeDialogPane createNodeDialogPane() {
        return new SpellCheckerNodeDialog();
    }

    protected NodeDescription createNodeDescription() throws SAXException, IOException, XmlException {
        NodeDescription description = super.createNodeDescription();
        final Element xmlDescription = description.getXMLDescription();
        SpellCheckerNodeFactory.augmentXmlDescription(xmlDescription);
        return new DelegateNodeDescription(description){

            public Element getXMLDescription() {
                return xmlDescription;
            }
        };
    }

    private static void augmentXmlDescription(Element xmlDescription) {
        Document d = xmlDescription.getOwnerDocument();
        Node placeholder = (Node)SpellCheckerNodeFactory.xPath(d, "//*[normalize-space() = 'PLACEHOLDER']", XPathConstants.NODE);
        if (placeholder == null) {
            NodeLogger.getLogger(SpellCheckerNodeFactory.class).coding((Object)"PLACEHOLDER element is missing -- cannot insert dynamic parts into description.");
        }
        String[] languageList = SpellCheckerNodeDialog.getLanguageList();
        Element ul = d.createElement("ul");
        String[] stringArray = languageList;
        int n = languageList.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            Element li = d.createElement("li");
            li.appendChild(d.createTextNode(language));
            ul.appendChild(li);
            ++n2;
        }
        placeholder.getParentNode().insertBefore(ul, placeholder);
        placeholder.getParentNode().removeChild(placeholder);
    }

    private static Object xPath(Document document, String xPath, QName returnType) {
        try {
            XPath xPathInstance = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xPathInstance.compile(xPath);
            return xPathExpression.evaluate(document, returnType);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath: " + xPath, e);
        }
    }
}

