/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.analyzerecipe;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import com.nodepit.nodes.spoonacular.Utils;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class AnalyzeRecipeNodeSettings {
    private static final String LANGUAGE_KEY = "language";
    private static final String LANGUAGE_DEFAULT_VALUE = null;
    private String language = LANGUAGE_DEFAULT_VALUE;
    private static final String LANGUAGE_ENABLED_KEY = "languageEnabled";
    private boolean languageEnabled = false;
    private static final String INCLUDE_NUTRITION_KEY = "includeNutrition";
    private static final boolean INCLUDE_NUTRITION_DEFAULT_VALUE = false;
    private boolean includeNutrition = false;
    private static final String INCLUDE_NUTRITION_ENABLED_KEY = "includeNutritionEnabled";
    private boolean includeNutritionEnabled = false;
    private static final String INCLUDE_TASTE_KEY = "includeTaste";
    private static final boolean INCLUDE_TASTE_DEFAULT_VALUE = false;
    private boolean includeTaste = false;
    private static final String INCLUDE_TASTE_ENABLED_KEY = "includeTasteEnabled";
    private boolean includeTasteEnabled = false;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", AnalyzeRecipeNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    AnalyzeRecipeNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(LANGUAGE_KEY, this.language);
        settings.addBoolean(LANGUAGE_ENABLED_KEY, this.languageEnabled);
        settings.addBoolean(INCLUDE_NUTRITION_KEY, this.includeNutrition);
        settings.addBoolean(INCLUDE_NUTRITION_ENABLED_KEY, this.includeNutritionEnabled);
        settings.addBoolean(INCLUDE_TASTE_KEY, this.includeTaste);
        settings.addBoolean(INCLUDE_TASTE_ENABLED_KEY, this.includeTasteEnabled);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.language = settings.getString(LANGUAGE_KEY, LANGUAGE_DEFAULT_VALUE);
        this.languageEnabled = settings.getBoolean(LANGUAGE_ENABLED_KEY, false);
        this.includeNutrition = settings.getBoolean(INCLUDE_NUTRITION_KEY, false);
        this.includeNutritionEnabled = settings.getBoolean(INCLUDE_NUTRITION_ENABLED_KEY, false);
        this.includeTaste = settings.getBoolean(INCLUDE_TASTE_KEY, false);
        this.includeTasteEnabled = settings.getBoolean(INCLUDE_TASTE_ENABLED_KEY, false);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String language() {
        return this.language;
    }

    void language(String value) {
        this.language = value;
    }

    boolean languageEnabled() {
        return this.languageEnabled;
    }

    void languageEnabled(boolean value) {
        this.languageEnabled = value;
    }

    boolean includeNutrition() {
        return this.includeNutrition;
    }

    void includeNutrition(boolean value) {
        this.includeNutrition = value;
    }

    boolean includeNutritionEnabled() {
        return this.includeNutritionEnabled;
    }

    void includeNutritionEnabled(boolean value) {
        this.includeNutritionEnabled = value;
    }

    boolean includeTaste() {
        return this.includeTaste;
    }

    void includeTaste(boolean value) {
        this.includeTaste = value;
    }

    boolean includeTasteEnabled() {
        return this.includeTasteEnabled;
    }

    void includeTasteEnabled(boolean value) {
        this.includeTasteEnabled = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

