/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.autocompleteingredientsearch;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.autocompleteingredientsearch.AutocompleteIngredientSearchNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AutocompleteIngredientSearchNodeDialog
extends NodeDialogPane {
    private final AutocompleteIngredientSearchNodeSettings nodeSettings = new AutocompleteIngredientSearchNodeSettings();
    private JTextField query;
    private JCheckBox queryEnabled;
    private JSpinner number;
    private JCheckBox numberEnabled;
    private JCheckBox metaInformation;
    private JCheckBox metaInformationEnabled;
    private JTextField intolerances;
    private JCheckBox intolerancesEnabled;
    private JComboBox<String> language;
    private JCheckBox languageEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    AutocompleteIngredientSearchNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Query:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.queryEnabled = new JCheckBox();
        this.queryEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.queryEnabled.setSelected(!this.queryEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.queryEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.query = new JTextField(30);
        panel.add((Component)this.query, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Number:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.numberEnabled = new JCheckBox();
        this.numberEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.numberEnabled.setSelected(!this.numberEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.numberEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.number = new JSpinner(new SpinnerNumberModel(AutocompleteIngredientSearchNodeSettings.NUMBER_DEFAULT_VALUE, AutocompleteIngredientSearchNodeSettings.NUMBER_MINIMUM_VALUE, AutocompleteIngredientSearchNodeSettings.NUMBER_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.number, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Meta Information:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.metaInformationEnabled = new JCheckBox();
        this.metaInformationEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.metaInformationEnabled.setSelected(!this.metaInformationEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.metaInformationEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.metaInformation = new JCheckBox("true");
        panel.add((Component)this.metaInformation, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Intolerances:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.intolerancesEnabled = new JCheckBox();
        this.intolerancesEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.intolerancesEnabled.setSelected(!this.intolerancesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.intolerancesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.intolerances = new JTextField(30);
        panel.add((Component)this.intolerances, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Language:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        this.languageEnabled = new JCheckBox();
        this.languageEnabled.addActionListener(e -> this.updateComponents());
        label4.addActionListener(e -> {
            this.languageEnabled.setSelected(!this.languageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.languageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.language = new JComboBox<String>(AutocompleteIngredientSearchNodeSettings.LANGUAGE_VALUES);
        panel.add(this.language, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AutocompleteIngredientSearchNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.query.setEnabled(this.queryEnabled.isSelected());
        this.number.setEnabled(this.numberEnabled.isSelected());
        this.metaInformation.setEnabled(this.metaInformationEnabled.isSelected());
        this.intolerances.setEnabled(this.intolerancesEnabled.isSelected());
        this.language.setEnabled(this.languageEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.query(this.query.getText());
        this.nodeSettings.queryEnabled(this.queryEnabled.isSelected());
        this.nodeSettings.number((Integer)this.number.getValue());
        this.nodeSettings.numberEnabled(this.numberEnabled.isSelected());
        this.nodeSettings.metaInformation(this.metaInformation.isSelected());
        this.nodeSettings.metaInformationEnabled(this.metaInformationEnabled.isSelected());
        this.nodeSettings.intolerances(this.intolerances.getText());
        this.nodeSettings.intolerancesEnabled(this.intolerancesEnabled.isSelected());
        this.nodeSettings.language((String)this.language.getSelectedItem());
        this.nodeSettings.languageEnabled(this.languageEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.query.setText(this.nodeSettings.query());
        this.queryEnabled.setSelected(this.nodeSettings.queryEnabled());
        this.number.setValue(this.nodeSettings.number());
        this.numberEnabled.setSelected(this.nodeSettings.numberEnabled());
        this.metaInformation.setSelected(this.nodeSettings.metaInformation());
        this.metaInformationEnabled.setSelected(this.nodeSettings.metaInformationEnabled());
        this.intolerances.setText(this.nodeSettings.intolerances());
        this.intolerancesEnabled.setSelected(this.nodeSettings.intolerancesEnabled());
        this.language.setSelectedItem(this.nodeSettings.language());
        this.languageEnabled.setSelected(this.nodeSettings.languageEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

