/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.computeingredientamount;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ComputeIngredientAmountNodeSettings {
    private static final String ID_KEY = "id";
    private static final String ID_DEFAULT_VALUE = null;
    private String id = ID_DEFAULT_VALUE;
    private static final String NUTRIENT_KEY = "nutrient";
    private static final String NUTRIENT_DEFAULT_VALUE = null;
    private String nutrient = NUTRIENT_DEFAULT_VALUE;
    private static final String TARGET_KEY = "target";
    private static final String TARGET_DEFAULT_VALUE = null;
    private String target = TARGET_DEFAULT_VALUE;
    private static final String UNIT_KEY = "unit";
    private static final String UNIT_DEFAULT_VALUE = null;
    private String unit = UNIT_DEFAULT_VALUE;
    private static final String UNIT_ENABLED_KEY = "unitEnabled";
    private boolean unitEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ComputeIngredientAmountNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ID_KEY, this.id);
        settings.addString(NUTRIENT_KEY, this.nutrient);
        settings.addString(TARGET_KEY, this.target);
        settings.addString(UNIT_KEY, this.unit);
        settings.addBoolean(UNIT_ENABLED_KEY, this.unitEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getString(ID_KEY, ID_DEFAULT_VALUE);
        this.nutrient = settings.getString(NUTRIENT_KEY, NUTRIENT_DEFAULT_VALUE);
        this.target = settings.getString(TARGET_KEY, TARGET_DEFAULT_VALUE);
        this.unit = settings.getString(UNIT_KEY, UNIT_DEFAULT_VALUE);
        this.unitEnabled = settings.getBoolean(UNIT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.nutrient == null || this.nutrient.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cNutrient\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String id() {
        return this.id;
    }

    void id(String value) {
        this.id = value;
    }

    String nutrient() {
        return this.nutrient;
    }

    void nutrient(String value) {
        this.nutrient = value;
    }

    String target() {
        return this.target;
    }

    void target(String value) {
        this.target = value;
    }

    String unit() {
        return this.unit;
    }

    void unit(String value) {
        this.unit = value;
    }

    boolean unitEnabled() {
        return this.unitEnabled;
    }

    void unitEnabled(boolean value) {
        this.unitEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

