/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.convertamounts;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ConvertAmountsNodeSettings {
    private static final String INGREDIENT_NAME_KEY = "ingredientName";
    private static final String INGREDIENT_NAME_DEFAULT_VALUE = null;
    private String ingredientName = INGREDIENT_NAME_DEFAULT_VALUE;
    private static final String SOURCE_AMOUNT_KEY = "sourceAmount";
    private static final String SOURCE_AMOUNT_DEFAULT_VALUE = null;
    private String sourceAmount = SOURCE_AMOUNT_DEFAULT_VALUE;
    private static final String SOURCE_UNIT_KEY = "sourceUnit";
    private static final String SOURCE_UNIT_DEFAULT_VALUE = null;
    private String sourceUnit = SOURCE_UNIT_DEFAULT_VALUE;
    private static final String TARGET_UNIT_KEY = "targetUnit";
    private static final String TARGET_UNIT_DEFAULT_VALUE = null;
    private String targetUnit = TARGET_UNIT_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ConvertAmountsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(INGREDIENT_NAME_KEY, this.ingredientName);
        settings.addString(SOURCE_AMOUNT_KEY, this.sourceAmount);
        settings.addString(SOURCE_UNIT_KEY, this.sourceUnit);
        settings.addString(TARGET_UNIT_KEY, this.targetUnit);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.ingredientName = settings.getString(INGREDIENT_NAME_KEY, INGREDIENT_NAME_DEFAULT_VALUE);
        this.sourceAmount = settings.getString(SOURCE_AMOUNT_KEY, SOURCE_AMOUNT_DEFAULT_VALUE);
        this.sourceUnit = settings.getString(SOURCE_UNIT_KEY, SOURCE_UNIT_DEFAULT_VALUE);
        this.targetUnit = settings.getString(TARGET_UNIT_KEY, TARGET_UNIT_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.ingredientName == null || this.ingredientName.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cIngredient Name\u201d is required.");
        }
        if (this.sourceUnit == null || this.sourceUnit.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cSource Unit\u201d is required.");
        }
        if (this.targetUnit == null || this.targetUnit.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTarget Unit\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String ingredientName() {
        return this.ingredientName;
    }

    void ingredientName(String value) {
        this.ingredientName = value;
    }

    String sourceAmount() {
        return this.sourceAmount;
    }

    void sourceAmount(String value) {
        this.sourceAmount = value;
    }

    String sourceUnit() {
        return this.sourceUnit;
    }

    void sourceUnit(String value) {
        this.sourceUnit = value;
    }

    String targetUnit() {
        return this.targetUnit;
    }

    void targetUnit(String value) {
        this.targetUnit = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

