/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.extractrecipefromwebsite;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ExtractRecipeFromWebsiteNodeSettings {
    private static final String URL_KEY = "url";
    private static final String URL_DEFAULT_VALUE = null;
    private String url = URL_DEFAULT_VALUE;
    private static final String FORCE_EXTRACTION_KEY = "forceExtraction";
    private static final boolean FORCE_EXTRACTION_DEFAULT_VALUE = false;
    private boolean forceExtraction = false;
    private static final String FORCE_EXTRACTION_ENABLED_KEY = "forceExtractionEnabled";
    private boolean forceExtractionEnabled = false;
    private static final String ANALYZE_KEY = "analyze";
    private static final boolean ANALYZE_DEFAULT_VALUE = false;
    private boolean analyze = false;
    private static final String ANALYZE_ENABLED_KEY = "analyzeEnabled";
    private boolean analyzeEnabled = false;
    private static final String INCLUDE_NUTRITION_KEY = "includeNutrition";
    private static final boolean INCLUDE_NUTRITION_DEFAULT_VALUE = false;
    private boolean includeNutrition = false;
    private static final String INCLUDE_NUTRITION_ENABLED_KEY = "includeNutritionEnabled";
    private boolean includeNutritionEnabled = false;
    private static final String INCLUDE_TASTE_KEY = "includeTaste";
    private static final boolean INCLUDE_TASTE_DEFAULT_VALUE = false;
    private boolean includeTaste = false;
    private static final String INCLUDE_TASTE_ENABLED_KEY = "includeTasteEnabled";
    private boolean includeTasteEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ExtractRecipeFromWebsiteNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(URL_KEY, this.url);
        settings.addBoolean(FORCE_EXTRACTION_KEY, this.forceExtraction);
        settings.addBoolean(FORCE_EXTRACTION_ENABLED_KEY, this.forceExtractionEnabled);
        settings.addBoolean(ANALYZE_KEY, this.analyze);
        settings.addBoolean(ANALYZE_ENABLED_KEY, this.analyzeEnabled);
        settings.addBoolean(INCLUDE_NUTRITION_KEY, this.includeNutrition);
        settings.addBoolean(INCLUDE_NUTRITION_ENABLED_KEY, this.includeNutritionEnabled);
        settings.addBoolean(INCLUDE_TASTE_KEY, this.includeTaste);
        settings.addBoolean(INCLUDE_TASTE_ENABLED_KEY, this.includeTasteEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.url = settings.getString(URL_KEY, URL_DEFAULT_VALUE);
        this.forceExtraction = settings.getBoolean(FORCE_EXTRACTION_KEY, false);
        this.forceExtractionEnabled = settings.getBoolean(FORCE_EXTRACTION_ENABLED_KEY, false);
        this.analyze = settings.getBoolean(ANALYZE_KEY, false);
        this.analyzeEnabled = settings.getBoolean(ANALYZE_ENABLED_KEY, false);
        this.includeNutrition = settings.getBoolean(INCLUDE_NUTRITION_KEY, false);
        this.includeNutritionEnabled = settings.getBoolean(INCLUDE_NUTRITION_ENABLED_KEY, false);
        this.includeTaste = settings.getBoolean(INCLUDE_TASTE_KEY, false);
        this.includeTasteEnabled = settings.getBoolean(INCLUDE_TASTE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.url == null || this.url.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cUrl\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String url() {
        return this.url;
    }

    void url(String value) {
        this.url = value;
    }

    boolean forceExtraction() {
        return this.forceExtraction;
    }

    void forceExtraction(boolean value) {
        this.forceExtraction = value;
    }

    boolean forceExtractionEnabled() {
        return this.forceExtractionEnabled;
    }

    void forceExtractionEnabled(boolean value) {
        this.forceExtractionEnabled = value;
    }

    boolean analyze() {
        return this.analyze;
    }

    void analyze(boolean value) {
        this.analyze = value;
    }

    boolean analyzeEnabled() {
        return this.analyzeEnabled;
    }

    void analyzeEnabled(boolean value) {
        this.analyzeEnabled = value;
    }

    boolean includeNutrition() {
        return this.includeNutrition;
    }

    void includeNutrition(boolean value) {
        this.includeNutrition = value;
    }

    boolean includeNutritionEnabled() {
        return this.includeNutritionEnabled;
    }

    void includeNutritionEnabled(boolean value) {
        this.includeNutritionEnabled = value;
    }

    boolean includeTaste() {
        return this.includeTaste;
    }

    void includeTaste(boolean value) {
        this.includeTaste = value;
    }

    boolean includeTasteEnabled() {
        return this.includeTasteEnabled;
    }

    void includeTasteEnabled(boolean value) {
        this.includeTasteEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

