/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.generatemealplan;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GenerateMealPlanNodeSettings {
    private static final String TIME_FRAME_KEY = "timeFrame";
    private static final String TIME_FRAME_DEFAULT_VALUE = null;
    private String timeFrame = TIME_FRAME_DEFAULT_VALUE;
    private static final String TIME_FRAME_ENABLED_KEY = "timeFrameEnabled";
    private boolean timeFrameEnabled = false;
    private static final String TARGET_CALORIES_KEY = "targetCalories";
    private static final String TARGET_CALORIES_DEFAULT_VALUE = null;
    private String targetCalories = TARGET_CALORIES_DEFAULT_VALUE;
    private static final String TARGET_CALORIES_ENABLED_KEY = "targetCaloriesEnabled";
    private boolean targetCaloriesEnabled = false;
    private static final String DIET_KEY = "diet";
    private static final String DIET_DEFAULT_VALUE = null;
    private String diet = DIET_DEFAULT_VALUE;
    private static final String DIET_ENABLED_KEY = "dietEnabled";
    private boolean dietEnabled = false;
    private static final String EXCLUDE_KEY = "exclude";
    private static final String EXCLUDE_DEFAULT_VALUE = null;
    private String exclude = EXCLUDE_DEFAULT_VALUE;
    private static final String EXCLUDE_ENABLED_KEY = "excludeEnabled";
    private boolean excludeEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GenerateMealPlanNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(TIME_FRAME_KEY, this.timeFrame);
        settings.addBoolean(TIME_FRAME_ENABLED_KEY, this.timeFrameEnabled);
        settings.addString(TARGET_CALORIES_KEY, this.targetCalories);
        settings.addBoolean(TARGET_CALORIES_ENABLED_KEY, this.targetCaloriesEnabled);
        settings.addString(DIET_KEY, this.diet);
        settings.addBoolean(DIET_ENABLED_KEY, this.dietEnabled);
        settings.addString(EXCLUDE_KEY, this.exclude);
        settings.addBoolean(EXCLUDE_ENABLED_KEY, this.excludeEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.timeFrame = settings.getString(TIME_FRAME_KEY, TIME_FRAME_DEFAULT_VALUE);
        this.timeFrameEnabled = settings.getBoolean(TIME_FRAME_ENABLED_KEY, false);
        this.targetCalories = settings.getString(TARGET_CALORIES_KEY, TARGET_CALORIES_DEFAULT_VALUE);
        this.targetCaloriesEnabled = settings.getBoolean(TARGET_CALORIES_ENABLED_KEY, false);
        this.diet = settings.getString(DIET_KEY, DIET_DEFAULT_VALUE);
        this.dietEnabled = settings.getBoolean(DIET_ENABLED_KEY, false);
        this.exclude = settings.getString(EXCLUDE_KEY, EXCLUDE_DEFAULT_VALUE);
        this.excludeEnabled = settings.getBoolean(EXCLUDE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String timeFrame() {
        return this.timeFrame;
    }

    void timeFrame(String value) {
        this.timeFrame = value;
    }

    boolean timeFrameEnabled() {
        return this.timeFrameEnabled;
    }

    void timeFrameEnabled(boolean value) {
        this.timeFrameEnabled = value;
    }

    String targetCalories() {
        return this.targetCalories;
    }

    void targetCalories(String value) {
        this.targetCalories = value;
    }

    boolean targetCaloriesEnabled() {
        return this.targetCaloriesEnabled;
    }

    void targetCaloriesEnabled(boolean value) {
        this.targetCaloriesEnabled = value;
    }

    String diet() {
        return this.diet;
    }

    void diet(String value) {
        this.diet = value;
    }

    boolean dietEnabled() {
        return this.dietEnabled;
    }

    void dietEnabled(boolean value) {
        this.dietEnabled = value;
    }

    String exclude() {
        return this.exclude;
    }

    void exclude(String value) {
        this.exclude = value;
    }

    boolean excludeEnabled() {
        return this.excludeEnabled;
    }

    void excludeEnabled(boolean value) {
        this.excludeEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

