/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getrandomrecipes;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetRandomRecipesNodeSettings {
    private static final String LIMIT_LICENSE_KEY = "limitLicense";
    private static final boolean LIMIT_LICENSE_DEFAULT_VALUE = true;
    private boolean limitLicense = true;
    private static final String LIMIT_LICENSE_ENABLED_KEY = "limitLicenseEnabled";
    private boolean limitLicenseEnabled = false;
    private static final String TAGS_KEY = "tags";
    private static final String TAGS_DEFAULT_VALUE = null;
    private String tags = TAGS_DEFAULT_VALUE;
    private static final String TAGS_ENABLED_KEY = "tagsEnabled";
    private boolean tagsEnabled = false;
    private static final String NUMBER_KEY = "number";
    static final Integer NUMBER_DEFAULT_VALUE = 10;
    static final Integer NUMBER_MINIMUM_VALUE = 1;
    static final Integer NUMBER_MAXIMUM_VALUE = 100;
    private int number = NUMBER_DEFAULT_VALUE;
    private static final String NUMBER_ENABLED_KEY = "numberEnabled";
    private boolean numberEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetRandomRecipesNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addBoolean(LIMIT_LICENSE_KEY, this.limitLicense);
        settings.addBoolean(LIMIT_LICENSE_ENABLED_KEY, this.limitLicenseEnabled);
        settings.addString(TAGS_KEY, this.tags);
        settings.addBoolean(TAGS_ENABLED_KEY, this.tagsEnabled);
        settings.addInt(NUMBER_KEY, this.number);
        settings.addBoolean(NUMBER_ENABLED_KEY, this.numberEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.limitLicense = settings.getBoolean(LIMIT_LICENSE_KEY, true);
        this.limitLicenseEnabled = settings.getBoolean(LIMIT_LICENSE_ENABLED_KEY, false);
        this.tags = settings.getString(TAGS_KEY, TAGS_DEFAULT_VALUE);
        this.tagsEnabled = settings.getBoolean(TAGS_ENABLED_KEY, false);
        this.number = settings.getInt(NUMBER_KEY, NUMBER_DEFAULT_VALUE.intValue());
        this.numberEnabled = settings.getBoolean(NUMBER_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    boolean limitLicense() {
        return this.limitLicense;
    }

    void limitLicense(boolean value) {
        this.limitLicense = value;
    }

    boolean limitLicenseEnabled() {
        return this.limitLicenseEnabled;
    }

    void limitLicenseEnabled(boolean value) {
        this.limitLicenseEnabled = value;
    }

    String tags() {
        return this.tags;
    }

    void tags(String value) {
        this.tags = value;
    }

    boolean tagsEnabled() {
        return this.tagsEnabled;
    }

    void tagsEnabled(boolean value) {
        this.tagsEnabled = value;
    }

    int number() {
        return this.number;
    }

    void number(int value) {
        this.number = value;
    }

    boolean numberEnabled() {
        return this.numberEnabled;
    }

    void numberEnabled(boolean value) {
        this.numberEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

