/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getrecipeinformation;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetRecipeInformationNodeSettings {
    private static final String ID_KEY = "id";
    static final Integer ID_DEFAULT_VALUE = 0;
    static final Integer ID_MINIMUM_VALUE = null;
    static final Integer ID_MAXIMUM_VALUE = null;
    private int id = ID_DEFAULT_VALUE;
    private static final String INCLUDE_NUTRITION_KEY = "includeNutrition";
    private static final boolean INCLUDE_NUTRITION_DEFAULT_VALUE = false;
    private boolean includeNutrition = false;
    private static final String INCLUDE_NUTRITION_ENABLED_KEY = "includeNutritionEnabled";
    private boolean includeNutritionEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetRecipeInformationNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(ID_KEY, this.id);
        settings.addBoolean(INCLUDE_NUTRITION_KEY, this.includeNutrition);
        settings.addBoolean(INCLUDE_NUTRITION_ENABLED_KEY, this.includeNutritionEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getInt(ID_KEY, ID_DEFAULT_VALUE.intValue());
        this.includeNutrition = settings.getBoolean(INCLUDE_NUTRITION_KEY, false);
        this.includeNutritionEnabled = settings.getBoolean(INCLUDE_NUTRITION_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int id() {
        return this.id;
    }

    void id(int value) {
        this.id = value;
    }

    boolean includeNutrition() {
        return this.includeNutrition;
    }

    void includeNutrition(boolean value) {
        this.includeNutrition = value;
    }

    boolean includeNutritionEnabled() {
        return this.includeNutritionEnabled;
    }

    void includeNutritionEnabled(boolean value) {
        this.includeNutritionEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

