/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getwinepairing;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.getwinepairing.GetWinePairingNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class GetWinePairingNodeDialog
extends NodeDialogPane {
    private final GetWinePairingNodeSettings nodeSettings = new GetWinePairingNodeSettings();
    private JTextField food;
    private JTextField maxPrice;
    private JCheckBox maxPriceEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    GetWinePairingNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Food:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.food = new JTextField(30);
        panel.add((Component)this.food, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Max Price:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.maxPriceEnabled = new JCheckBox();
        this.maxPriceEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.maxPriceEnabled.setSelected(!this.maxPriceEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.maxPriceEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.maxPrice = new JTextField(30);
        panel.add((Component)this.maxPrice, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(GetWinePairingNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.maxPrice.setEnabled(this.maxPriceEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.food(this.food.getText());
        this.nodeSettings.maxPrice(this.maxPrice.getText());
        this.nodeSettings.maxPriceEnabled(this.maxPriceEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.food.setText(this.nodeSettings.food());
        this.maxPrice.setText(this.nodeSettings.maxPrice());
        this.maxPriceEnabled.setSelected(this.nodeSettings.maxPriceEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

