/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getwinepairing;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetWinePairingNodeSettings {
    private static final String FOOD_KEY = "food";
    private static final String FOOD_DEFAULT_VALUE = null;
    private String food = FOOD_DEFAULT_VALUE;
    private static final String MAX_PRICE_KEY = "maxPrice";
    private static final String MAX_PRICE_DEFAULT_VALUE = null;
    private String maxPrice = MAX_PRICE_DEFAULT_VALUE;
    private static final String MAX_PRICE_ENABLED_KEY = "maxPriceEnabled";
    private boolean maxPriceEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetWinePairingNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FOOD_KEY, this.food);
        settings.addString(MAX_PRICE_KEY, this.maxPrice);
        settings.addBoolean(MAX_PRICE_ENABLED_KEY, this.maxPriceEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.food = settings.getString(FOOD_KEY, FOOD_DEFAULT_VALUE);
        this.maxPrice = settings.getString(MAX_PRICE_KEY, MAX_PRICE_DEFAULT_VALUE);
        this.maxPriceEnabled = settings.getBoolean(MAX_PRICE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.food == null || this.food.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFood\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String food() {
        return this.food;
    }

    void food(String value) {
        this.food = value;
    }

    String maxPrice() {
        return this.maxPrice;
    }

    void maxPrice(String value) {
        this.maxPrice = value;
    }

    boolean maxPriceEnabled() {
        return this.maxPriceEnabled;
    }

    void maxPriceEnabled(boolean value) {
        this.maxPriceEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

