/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.recipetastebyidimage;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class RecipeTasteByIDImageNodeSettings {
    private static final String ID_KEY = "id";
    private static final String ID_DEFAULT_VALUE = null;
    private String id = ID_DEFAULT_VALUE;
    private static final String NORMALIZE_KEY = "normalize";
    private static final boolean NORMALIZE_DEFAULT_VALUE = false;
    private boolean normalize = false;
    private static final String NORMALIZE_ENABLED_KEY = "normalizeEnabled";
    private boolean normalizeEnabled = false;
    private static final String RGB_KEY = "rgb";
    private static final String RGB_DEFAULT_VALUE = null;
    private String rgb = RGB_DEFAULT_VALUE;
    private static final String RGB_ENABLED_KEY = "rgbEnabled";
    private boolean rgbEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    RecipeTasteByIDImageNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ID_KEY, this.id);
        settings.addBoolean(NORMALIZE_KEY, this.normalize);
        settings.addBoolean(NORMALIZE_ENABLED_KEY, this.normalizeEnabled);
        settings.addString(RGB_KEY, this.rgb);
        settings.addBoolean(RGB_ENABLED_KEY, this.rgbEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getString(ID_KEY, ID_DEFAULT_VALUE);
        this.normalize = settings.getBoolean(NORMALIZE_KEY, false);
        this.normalizeEnabled = settings.getBoolean(NORMALIZE_ENABLED_KEY, false);
        this.rgb = settings.getString(RGB_KEY, RGB_DEFAULT_VALUE);
        this.rgbEnabled = settings.getBoolean(RGB_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String id() {
        return this.id;
    }

    void id(String value) {
        this.id = value;
    }

    boolean normalize() {
        return this.normalize;
    }

    void normalize(boolean value) {
        this.normalize = value;
    }

    boolean normalizeEnabled() {
        return this.normalizeEnabled;
    }

    void normalizeEnabled(boolean value) {
        this.normalizeEnabled = value;
    }

    String rgb() {
        return this.rgb;
    }

    void rgb(String value) {
        this.rgb = value;
    }

    boolean rgbEnabled() {
        return this.rgbEnabled;
    }

    void rgbEnabled(boolean value) {
        this.rgbEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

