/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.searchcustomfoods;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchCustomFoodsNodeSettings {
    private static final String QUERY_KEY = "query";
    private static final String QUERY_DEFAULT_VALUE = null;
    private String query = QUERY_DEFAULT_VALUE;
    private static final String QUERY_ENABLED_KEY = "queryEnabled";
    private boolean queryEnabled = false;
    private static final String USERNAME_KEY = "username";
    private static final String USERNAME_DEFAULT_VALUE = null;
    private String username = USERNAME_DEFAULT_VALUE;
    private static final String HASH_KEY = "hash";
    private static final String HASH_DEFAULT_VALUE = null;
    private String hash = HASH_DEFAULT_VALUE;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = 0;
    static final Integer OFFSET_MAXIMUM_VALUE = 900;
    private int offset = OFFSET_DEFAULT_VALUE;
    private static final String OFFSET_ENABLED_KEY = "offsetEnabled";
    private boolean offsetEnabled = false;
    private static final String NUMBER_KEY = "number";
    static final Integer NUMBER_DEFAULT_VALUE = 10;
    static final Integer NUMBER_MINIMUM_VALUE = 1;
    static final Integer NUMBER_MAXIMUM_VALUE = 100;
    private int number = NUMBER_DEFAULT_VALUE;
    private static final String NUMBER_ENABLED_KEY = "numberEnabled";
    private boolean numberEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchCustomFoodsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(QUERY_KEY, this.query);
        settings.addBoolean(QUERY_ENABLED_KEY, this.queryEnabled);
        settings.addString(USERNAME_KEY, this.username);
        settings.addString(HASH_KEY, this.hash);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addBoolean(OFFSET_ENABLED_KEY, this.offsetEnabled);
        settings.addInt(NUMBER_KEY, this.number);
        settings.addBoolean(NUMBER_ENABLED_KEY, this.numberEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.query = settings.getString(QUERY_KEY, QUERY_DEFAULT_VALUE);
        this.queryEnabled = settings.getBoolean(QUERY_ENABLED_KEY, false);
        this.username = settings.getString(USERNAME_KEY, USERNAME_DEFAULT_VALUE);
        this.hash = settings.getString(HASH_KEY, HASH_DEFAULT_VALUE);
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.offsetEnabled = settings.getBoolean(OFFSET_ENABLED_KEY, false);
        this.number = settings.getInt(NUMBER_KEY, NUMBER_DEFAULT_VALUE.intValue());
        this.numberEnabled = settings.getBoolean(NUMBER_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.username == null || this.username.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cUsername\u201d is required.");
        }
        if (this.hash == null || this.hash.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cHash\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String query() {
        return this.query;
    }

    void query(String value) {
        this.query = value;
    }

    boolean queryEnabled() {
        return this.queryEnabled;
    }

    void queryEnabled(boolean value) {
        this.queryEnabled = value;
    }

    String username() {
        return this.username;
    }

    void username(String value) {
        this.username = value;
    }

    String hash() {
        return this.hash;
    }

    void hash(String value) {
        this.hash = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    boolean offsetEnabled() {
        return this.offsetEnabled;
    }

    void offsetEnabled(boolean value) {
        this.offsetEnabled = value;
    }

    int number() {
        return this.number;
    }

    void number(int value) {
        this.number = value;
    }

    boolean numberEnabled() {
        return this.numberEnabled;
    }

    void numberEnabled(boolean value) {
        this.numberEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

