/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.timeout;

import com.nodepit.nodes.spoonacular.port.ConfigPortObject;
import com.nodepit.nodes.spoonacular.port.ConfigPortObjectSpec;
import com.nodepit.nodes.spoonacular.timeout.TimeoutInterceptorFactory;
import com.nodepit.nodes.spoonacular.timeout.TimeoutNodeSettings;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class TimeoutNodeModel
extends NodeModel {
    private final TimeoutNodeSettings nodeSettings = new TimeoutNodeSettings();

    protected TimeoutNodeModel() {
        super(new PortType[]{ConfigPortObject.TYPE_OPTIONAL}, new PortType[]{ConfigPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PortObjectSpec spec = Optional.ofNullable(inObjects[0]).map(PortObject::getSpec).orElse(null);
        return new PortObject[]{new ConfigPortObject(this.createSpec((ConfigPortObjectSpec)spec))};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{this.createSpec((ConfigPortObjectSpec)inSpecs[0])};
    }

    private ConfigPortObjectSpec createSpec(ConfigPortObjectSpec inSpec) {
        ConfigPortObjectSpec spec = ConfigPortObjectSpec.getOrDefault(inSpec);
        TimeoutInterceptorFactory.TimeoutData data = new TimeoutInterceptorFactory.TimeoutData();
        data.connectTimeout = this.nodeSettings.connectTimeout();
        data.readTimeout = this.nodeSettings.readTimeout();
        data.writeTimeout = this.nodeSettings.writeTimeout();
        return spec.append(new ConfigPortObjectSpec.InterceptorConfig("timeout", data));
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

