/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.chainr.ChainrBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataCellFactory;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;

public final class TransformToTableMapper
implements ResponseMapper {
    private final Chainr chainr;
    private final DataColumnSpecEntry[] colSpecs;

    private TransformToTableMapper(String joltMappingJson, DataColumnSpecEntry[] colSpecs) {
        Object jsonMappingSpec = TransformToTableMapper.parseJson(joltMappingJson, Object.class);
        this.chainr = new ChainrBuilder(jsonMappingSpec).build();
        this.colSpecs = colSpecs;
    }

    @Override
    public DataTableSpec getSpec(String responseType) {
        return this.getSpec();
    }

    @Override
    public BufferedDataTable getTable(ExecutionContext exec, Response response, String responseType) throws IOException {
        Object jsonObject = TransformToTableMapper.parseJson(response.body().string(), Object.class);
        Object transformed = this.chainr.transform(jsonObject);
        String transformedString = TransformToTableMapper.stringifyJson(transformed);
        MappingSpec mappingSpec = TransformToTableMapper.parseJson(transformedString, MappingSpec.class);
        DataTableSpec outputSpec = this.getSpec();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        if (mappingSpec != null) {
            long idx = 0L;
            for (List<Object> row : mappingSpec.rows) {
                ArrayList<DataCell> tableCells = new ArrayList<DataCell>();
                int cellIdx = 0;
                while (cellIdx < outputSpec.getNumColumns()) {
                    DataCell cell;
                    if (cellIdx >= row.size()) {
                        cell = DataType.getMissingCell();
                    } else {
                        Object value = row.get(cellIdx);
                        DataColumnSpecEntry specEntry = this.colSpecs[cellIdx];
                        DataType type = specEntry.spec.getType();
                        if (value == null) {
                            cell = DataType.getMissingCell();
                        } else if (specEntry.isBinary) {
                            byte[] bytes = Base64.getDecoder().decode(String.valueOf(value));
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                            DataCellFactory cellFactory = (DataCellFactory)type.getCellFactory(exec).orElseThrow();
                            if (!(cellFactory instanceof DataCellFactory.FromInputStream)) {
                                throw new IllegalStateException(cellFactory + " does not implement FromInputStream");
                            }
                            cell = ((DataCellFactory.FromInputStream)cellFactory).createCell((InputStream)inputStream);
                        } else {
                            String stringValue = value instanceof List || value instanceof Map ? TransformToTableMapper.stringifyJson(value) : String.valueOf(value);
                            DataCellFactory cellFactory = (DataCellFactory)type.getCellFactory(exec).orElseThrow();
                            if (!(cellFactory instanceof DataCellFactory.FromString)) {
                                throw new IllegalStateException(cellFactory + " does not implement FromString");
                            }
                            cell = ((DataCellFactory.FromString)cellFactory).createCell(stringValue);
                        }
                    }
                    tableCells.add(cell);
                    ++cellIdx;
                }
                DefaultRow tableRow = new DefaultRow(RowKey.createRowKey((long)idx++), (DataCell[])tableCells.toArray(DataCell[]::new));
                container.addRowToTable((DataRow)tableRow);
            }
        }
        container.close();
        return container.getTable();
    }

    private DataTableSpec getSpec() {
        DataTableSpecCreator specCreator = new DataTableSpecCreator();
        specCreator.addColumns((DataColumnSpec[])Arrays.stream(this.colSpecs).map(spec -> spec.spec).toArray(DataColumnSpec[]::new));
        return specCreator.createSpec();
    }

    private static <T> T parseJson(String json, Class<T> type) {
        try {
            return (T)new ObjectMapper().readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not parse JSON", e);
        }
    }

    private static String stringifyJson(Object object) {
        try {
            return new ObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not stringify JSON", e);
        }
    }

    @Override
    public String label() {
        return "Structured Table";
    }

    @Override
    public String identifier() {
        return "table";
    }

    @Override
    public boolean supportsResponseType(String responseType) {
        return responseType != null && responseType.endsWith("json");
    }

    public static final class Builder {
        private String joltMappingJson;
        private final List<DataColumnSpecEntry> colSpecs = new ArrayList<DataColumnSpecEntry>();

        public Builder useJoltMapping(String joltMappingJson) {
            this.joltMappingJson = joltMappingJson;
            return this;
        }

        public Builder addBodyColumn(DataColumnSpec spec, boolean isBinary) {
            this.colSpecs.add(new DataColumnSpecEntry(spec, isBinary));
            return this;
        }

        public Builder addBodyColumn(DataColumnSpec spec) {
            return this.addBodyColumn(spec, false);
        }

        public TransformToTableMapper build() {
            return new TransformToTableMapper(this.joltMappingJson, (DataColumnSpecEntry[])this.colSpecs.toArray(DataColumnSpecEntry[]::new));
        }
    }

    private static final class DataColumnSpecEntry {
        final DataColumnSpec spec;
        final boolean isBinary;

        DataColumnSpecEntry(DataColumnSpec spec, boolean isBinary) {
            this.spec = spec;
            this.isBinary = isBinary;
        }
    }

    public static final class MappingSpec {
        public List<List<Object>> rows;
    }
}

