/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.autocompleterecipesearch;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.autocompleterecipesearch.AutocompleteRecipeSearchNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AutocompleteRecipeSearchNodeDialog
extends NodeDialogPane {
    private final AutocompleteRecipeSearchNodeSettings nodeSettings = new AutocompleteRecipeSearchNodeSettings();
    private JTextField query;
    private JCheckBox queryEnabled;
    private JSpinner number;
    private JCheckBox numberEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    AutocompleteRecipeSearchNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Query:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.queryEnabled = new JCheckBox();
        this.queryEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.queryEnabled.setSelected(!this.queryEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.queryEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.query = new JTextField(30);
        panel.add((Component)this.query, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Number:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.numberEnabled = new JCheckBox();
        this.numberEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.numberEnabled.setSelected(!this.numberEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.numberEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.number = new JSpinner(new SpinnerNumberModel(AutocompleteRecipeSearchNodeSettings.NUMBER_DEFAULT_VALUE, AutocompleteRecipeSearchNodeSettings.NUMBER_MINIMUM_VALUE, AutocompleteRecipeSearchNodeSettings.NUMBER_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.number, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AutocompleteRecipeSearchNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.query.setEnabled(this.queryEnabled.isSelected());
        this.number.setEnabled(this.numberEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.query(this.query.getText());
        this.nodeSettings.queryEnabled(this.queryEnabled.isSelected());
        this.nodeSettings.number((Integer)this.number.getValue());
        this.nodeSettings.numberEnabled(this.numberEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.query.setText(this.nodeSettings.query());
        this.queryEnabled.setSelected(this.nodeSettings.queryEnabled());
        this.number.setValue(this.nodeSettings.number());
        this.numberEnabled.setSelected(this.nodeSettings.numberEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

