/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.classifycuisine;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.classifycuisine.ClassifyCuisineNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ClassifyCuisineNodeDialog
extends NodeDialogPane {
    private final ClassifyCuisineNodeSettings nodeSettings = new ClassifyCuisineNodeSettings();
    private JComboBox<String> contentType;
    private JCheckBox contentTypeEnabled;
    private JTextField body;
    private JComboBox<ResponseMapper> resultFormat;

    ClassifyCuisineNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Content Type:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.contentTypeEnabled = new JCheckBox();
        this.contentTypeEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.contentTypeEnabled.setSelected(!this.contentTypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.contentTypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.contentType = new JComboBox<String>(ClassifyCuisineNodeSettings.CONTENT_TYPE_VALUES);
        panel.add(this.contentType, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Body:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.body = new JTextField(30);
        panel.add((Component)this.body, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ClassifyCuisineNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.contentType.setEnabled(this.contentTypeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.contentType((String)this.contentType.getSelectedItem());
        this.nodeSettings.contentTypeEnabled(this.contentTypeEnabled.isSelected());
        this.nodeSettings.body(this.body.getText());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.contentType.setSelectedItem(this.nodeSettings.contentType());
        this.contentTypeEnabled.setSelected(this.nodeSettings.contentTypeEnabled());
        this.body.setText(this.nodeSettings.body());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

