/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.classifygroceryproduct;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import com.nodepit.nodes.spoonacular.Utils;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ClassifyGroceryProductNodeSettings {
    static final String[] LOCALE_VALUES = new String[]{"en_US", "en_GB"};
    private static final String LOCALE_KEY = "locale";
    private static final String LOCALE_DEFAULT_VALUE = LOCALE_VALUES[0];
    private String locale = LOCALE_DEFAULT_VALUE;
    private static final String LOCALE_ENABLED_KEY = "localeEnabled";
    private boolean localeEnabled = false;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", ClassifyGroceryProductNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ClassifyGroceryProductNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(LOCALE_KEY, this.locale);
        settings.addBoolean(LOCALE_ENABLED_KEY, this.localeEnabled);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.locale = settings.getString(LOCALE_KEY, LOCALE_DEFAULT_VALUE);
        this.localeEnabled = settings.getBoolean(LOCALE_ENABLED_KEY, false);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String locale() {
        return this.locale;
    }

    void locale(String value) {
        this.locale = value;
    }

    boolean localeEnabled() {
        return this.localeEnabled;
    }

    void localeEnabled(boolean value) {
        this.localeEnabled = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

