/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getingredientinformation;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetIngredientInformationNodeSettings {
    private static final String ID_KEY = "id";
    static final Integer ID_DEFAULT_VALUE = 0;
    static final Integer ID_MINIMUM_VALUE = null;
    static final Integer ID_MAXIMUM_VALUE = null;
    private int id = ID_DEFAULT_VALUE;
    private static final String AMOUNT_KEY = "amount";
    private static final String AMOUNT_DEFAULT_VALUE = null;
    private String amount = AMOUNT_DEFAULT_VALUE;
    private static final String AMOUNT_ENABLED_KEY = "amountEnabled";
    private boolean amountEnabled = false;
    private static final String UNIT_KEY = "unit";
    private static final String UNIT_DEFAULT_VALUE = null;
    private String unit = UNIT_DEFAULT_VALUE;
    private static final String UNIT_ENABLED_KEY = "unitEnabled";
    private boolean unitEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetIngredientInformationNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(ID_KEY, this.id);
        settings.addString(AMOUNT_KEY, this.amount);
        settings.addBoolean(AMOUNT_ENABLED_KEY, this.amountEnabled);
        settings.addString(UNIT_KEY, this.unit);
        settings.addBoolean(UNIT_ENABLED_KEY, this.unitEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getInt(ID_KEY, ID_DEFAULT_VALUE.intValue());
        this.amount = settings.getString(AMOUNT_KEY, AMOUNT_DEFAULT_VALUE);
        this.amountEnabled = settings.getBoolean(AMOUNT_ENABLED_KEY, false);
        this.unit = settings.getString(UNIT_KEY, UNIT_DEFAULT_VALUE);
        this.unitEnabled = settings.getBoolean(UNIT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int id() {
        return this.id;
    }

    void id(int value) {
        this.id = value;
    }

    String amount() {
        return this.amount;
    }

    void amount(String value) {
        this.amount = value;
    }

    boolean amountEnabled() {
        return this.amountEnabled;
    }

    void amountEnabled(boolean value) {
        this.amountEnabled = value;
    }

    String unit() {
        return this.unit;
    }

    void unit(String value) {
        this.unit = value;
    }

    boolean unitEnabled() {
        return this.unitEnabled;
    }

    void unitEnabled(boolean value) {
        this.unitEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

