/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.searchallfood;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchAllFoodNodeSettings {
    private static final String QUERY_KEY = "query";
    private static final String QUERY_DEFAULT_VALUE = null;
    private String query = QUERY_DEFAULT_VALUE;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = 0;
    static final Integer OFFSET_MAXIMUM_VALUE = 900;
    private int offset = OFFSET_DEFAULT_VALUE;
    private static final String OFFSET_ENABLED_KEY = "offsetEnabled";
    private boolean offsetEnabled = false;
    private static final String NUMBER_KEY = "number";
    static final Integer NUMBER_DEFAULT_VALUE = 10;
    static final Integer NUMBER_MINIMUM_VALUE = 1;
    static final Integer NUMBER_MAXIMUM_VALUE = 100;
    private int number = NUMBER_DEFAULT_VALUE;
    private static final String NUMBER_ENABLED_KEY = "numberEnabled";
    private boolean numberEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchAllFoodNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(QUERY_KEY, this.query);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addBoolean(OFFSET_ENABLED_KEY, this.offsetEnabled);
        settings.addInt(NUMBER_KEY, this.number);
        settings.addBoolean(NUMBER_ENABLED_KEY, this.numberEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.query = settings.getString(QUERY_KEY, QUERY_DEFAULT_VALUE);
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.offsetEnabled = settings.getBoolean(OFFSET_ENABLED_KEY, false);
        this.number = settings.getInt(NUMBER_KEY, NUMBER_DEFAULT_VALUE.intValue());
        this.numberEnabled = settings.getBoolean(NUMBER_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.query == null || this.query.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cQuery\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String query() {
        return this.query;
    }

    void query(String value) {
        this.query = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    boolean offsetEnabled() {
        return this.offsetEnabled;
    }

    void offsetEnabled(boolean value) {
        this.offsetEnabled = value;
    }

    int number() {
        return this.number;
    }

    void number(int value) {
        this.number = value;
    }

    boolean numberEnabled() {
        return this.numberEnabled;
    }

    void numberEnabled(boolean value) {
        this.numberEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

