/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.visualizemenuitemnutritionbyid;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class VisualizeMenuItemNutritionByIDNodeSettings {
    private static final String ID_KEY = "id";
    static final Integer ID_DEFAULT_VALUE = 0;
    static final Integer ID_MINIMUM_VALUE = null;
    static final Integer ID_MAXIMUM_VALUE = null;
    private int id = ID_DEFAULT_VALUE;
    private static final String DEFAULT_CSS_KEY = "defaultCss";
    private static final boolean DEFAULT_CSS_DEFAULT_VALUE = true;
    private boolean defaultCss = true;
    private static final String DEFAULT_CSS_ENABLED_KEY = "defaultCssEnabled";
    private boolean defaultCssEnabled = false;
    static final String[] ACCEPT_VALUES = new String[]{"application/json", "text/html", "media/*"};
    private static final String ACCEPT_KEY = "accept";
    private static final String ACCEPT_DEFAULT_VALUE = ACCEPT_VALUES[0];
    private String accept = ACCEPT_DEFAULT_VALUE;
    private static final String ACCEPT_ENABLED_KEY = "acceptEnabled";
    private boolean acceptEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    VisualizeMenuItemNutritionByIDNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(ID_KEY, this.id);
        settings.addBoolean(DEFAULT_CSS_KEY, this.defaultCss);
        settings.addBoolean(DEFAULT_CSS_ENABLED_KEY, this.defaultCssEnabled);
        settings.addString(ACCEPT_KEY, this.accept);
        settings.addBoolean(ACCEPT_ENABLED_KEY, this.acceptEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getInt(ID_KEY, ID_DEFAULT_VALUE.intValue());
        this.defaultCss = settings.getBoolean(DEFAULT_CSS_KEY, true);
        this.defaultCssEnabled = settings.getBoolean(DEFAULT_CSS_ENABLED_KEY, false);
        this.accept = settings.getString(ACCEPT_KEY, ACCEPT_DEFAULT_VALUE);
        this.acceptEnabled = settings.getBoolean(ACCEPT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int id() {
        return this.id;
    }

    void id(int value) {
        this.id = value;
    }

    boolean defaultCss() {
        return this.defaultCss;
    }

    void defaultCss(boolean value) {
        this.defaultCss = value;
    }

    boolean defaultCssEnabled() {
        return this.defaultCssEnabled;
    }

    void defaultCssEnabled(boolean value) {
        this.defaultCssEnabled = value;
    }

    String accept() {
        return this.accept;
    }

    void accept(String value) {
        this.accept = value;
    }

    boolean acceptEnabled() {
        return this.acceptEnabled;
    }

    void acceptEnabled(boolean value) {
        this.acceptEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

