/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.visualizerecipetaste;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class VisualizeRecipeTasteNodeSettings {
    static final String[] LANGUAGE_VALUES = new String[]{"en", "de"};
    private static final String LANGUAGE_KEY = "language";
    private static final String LANGUAGE_DEFAULT_VALUE = LANGUAGE_VALUES[0];
    private String language = LANGUAGE_DEFAULT_VALUE;
    private static final String LANGUAGE_ENABLED_KEY = "languageEnabled";
    private boolean languageEnabled = false;
    static final String[] CONTENT_TYPE_VALUES = new String[]{"application/x-www-form-urlencoded", "application/json", "multipart/form-data"};
    private static final String CONTENT_TYPE_KEY = "contentType";
    private static final String CONTENT_TYPE_DEFAULT_VALUE = CONTENT_TYPE_VALUES[0];
    private String contentType = CONTENT_TYPE_DEFAULT_VALUE;
    private static final String CONTENT_TYPE_ENABLED_KEY = "contentTypeEnabled";
    private boolean contentTypeEnabled = false;
    static final String[] ACCEPT_VALUES = new String[]{"application/json", "text/html", "media/*"};
    private static final String ACCEPT_KEY = "accept";
    private static final String ACCEPT_DEFAULT_VALUE = ACCEPT_VALUES[0];
    private String accept = ACCEPT_DEFAULT_VALUE;
    private static final String ACCEPT_ENABLED_KEY = "acceptEnabled";
    private boolean acceptEnabled = false;
    private static final String NORMALIZE_KEY = "normalize";
    private static final boolean NORMALIZE_DEFAULT_VALUE = false;
    private boolean normalize = false;
    private static final String NORMALIZE_ENABLED_KEY = "normalizeEnabled";
    private boolean normalizeEnabled = false;
    private static final String RGB_KEY = "rgb";
    private static final String RGB_DEFAULT_VALUE = null;
    private String rgb = RGB_DEFAULT_VALUE;
    private static final String RGB_ENABLED_KEY = "rgbEnabled";
    private boolean rgbEnabled = false;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = null;
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    VisualizeRecipeTasteNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(LANGUAGE_KEY, this.language);
        settings.addBoolean(LANGUAGE_ENABLED_KEY, this.languageEnabled);
        settings.addString(CONTENT_TYPE_KEY, this.contentType);
        settings.addBoolean(CONTENT_TYPE_ENABLED_KEY, this.contentTypeEnabled);
        settings.addString(ACCEPT_KEY, this.accept);
        settings.addBoolean(ACCEPT_ENABLED_KEY, this.acceptEnabled);
        settings.addBoolean(NORMALIZE_KEY, this.normalize);
        settings.addBoolean(NORMALIZE_ENABLED_KEY, this.normalizeEnabled);
        settings.addString(RGB_KEY, this.rgb);
        settings.addBoolean(RGB_ENABLED_KEY, this.rgbEnabled);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.language = settings.getString(LANGUAGE_KEY, LANGUAGE_DEFAULT_VALUE);
        this.languageEnabled = settings.getBoolean(LANGUAGE_ENABLED_KEY, false);
        this.contentType = settings.getString(CONTENT_TYPE_KEY, CONTENT_TYPE_DEFAULT_VALUE);
        this.contentTypeEnabled = settings.getBoolean(CONTENT_TYPE_ENABLED_KEY, false);
        this.accept = settings.getString(ACCEPT_KEY, ACCEPT_DEFAULT_VALUE);
        this.acceptEnabled = settings.getBoolean(ACCEPT_ENABLED_KEY, false);
        this.normalize = settings.getBoolean(NORMALIZE_KEY, false);
        this.normalizeEnabled = settings.getBoolean(NORMALIZE_ENABLED_KEY, false);
        this.rgb = settings.getString(RGB_KEY, RGB_DEFAULT_VALUE);
        this.rgbEnabled = settings.getBoolean(RGB_ENABLED_KEY, false);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String language() {
        return this.language;
    }

    void language(String value) {
        this.language = value;
    }

    boolean languageEnabled() {
        return this.languageEnabled;
    }

    void languageEnabled(boolean value) {
        this.languageEnabled = value;
    }

    String contentType() {
        return this.contentType;
    }

    void contentType(String value) {
        this.contentType = value;
    }

    boolean contentTypeEnabled() {
        return this.contentTypeEnabled;
    }

    void contentTypeEnabled(boolean value) {
        this.contentTypeEnabled = value;
    }

    String accept() {
        return this.accept;
    }

    void accept(String value) {
        this.accept = value;
    }

    boolean acceptEnabled() {
        return this.acceptEnabled;
    }

    void acceptEnabled(boolean value) {
        this.acceptEnabled = value;
    }

    boolean normalize() {
        return this.normalize;
    }

    void normalize(boolean value) {
        this.normalize = value;
    }

    boolean normalizeEnabled() {
        return this.normalizeEnabled;
    }

    void normalizeEnabled(boolean value) {
        this.normalizeEnabled = value;
    }

    String rgb() {
        return this.rgb;
    }

    void rgb(String value) {
        this.rgb = value;
    }

    boolean rgbEnabled() {
        return this.rgbEnabled;
    }

    void rgbEnabled(boolean value) {
        this.rgbEnabled = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

