/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.analyzerecipe;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.analyzerecipe.AnalyzeRecipeNodeSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AnalyzeRecipeNodeDialog
extends NodeDialogPane {
    private final AnalyzeRecipeNodeSettings nodeSettings = new AnalyzeRecipeNodeSettings();
    private JTextField language;
    private JCheckBox languageEnabled;
    private JCheckBox includeNutrition;
    private JCheckBox includeNutritionEnabled;
    private JCheckBox includeTaste;
    private JCheckBox includeTasteEnabled;
    private RTextScrollPane body;
    private JComboBox<ResponseMapper> resultFormat;

    AnalyzeRecipeNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Language:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.languageEnabled = new JCheckBox();
        this.languageEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.languageEnabled.setSelected(!this.languageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.languageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.language = new JTextField(30);
        panel.add((Component)this.language, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Include Nutrition:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.includeNutritionEnabled = new JCheckBox();
        this.includeNutritionEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.includeNutritionEnabled.setSelected(!this.includeNutritionEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.includeNutritionEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.includeNutrition = new JCheckBox("true");
        panel.add((Component)this.includeNutrition, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Include Taste:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.includeTasteEnabled = new JCheckBox();
        this.includeTasteEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.includeTasteEnabled.setSelected(!this.includeTasteEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.includeTasteEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.includeTaste = new JCheckBox("true");
        panel.add((Component)this.includeTaste, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Body:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        RSyntaxTextArea textArea3 = new RSyntaxTextArea();
        textArea3.setCodeFoldingEnabled(true);
        textArea3.setSyntaxEditingStyle("text/json");
        textArea3.setAntiAliasingEnabled(true);
        this.body = new RTextScrollPane((RTextArea)textArea3);
        this.body.setPreferredSize(new Dimension(400, 300));
        panel.add((Component)this.body, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AnalyzeRecipeNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.language.setEnabled(this.languageEnabled.isSelected());
        this.includeNutrition.setEnabled(this.includeNutritionEnabled.isSelected());
        this.includeTaste.setEnabled(this.includeTasteEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.language(this.language.getText());
        this.nodeSettings.languageEnabled(this.languageEnabled.isSelected());
        this.nodeSettings.includeNutrition(this.includeNutrition.isSelected());
        this.nodeSettings.includeNutritionEnabled(this.includeNutritionEnabled.isSelected());
        this.nodeSettings.includeTaste(this.includeTaste.isSelected());
        this.nodeSettings.includeTasteEnabled(this.includeTasteEnabled.isSelected());
        this.nodeSettings.body(this.body.getTextArea().getText());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.language.setText(this.nodeSettings.language());
        this.languageEnabled.setSelected(this.nodeSettings.languageEnabled());
        this.includeNutrition.setSelected(this.nodeSettings.includeNutrition());
        this.includeNutritionEnabled.setSelected(this.nodeSettings.includeNutritionEnabled());
        this.includeTaste.setSelected(this.nodeSettings.includeTaste());
        this.includeTasteEnabled.setSelected(this.nodeSettings.includeTasteEnabled());
        this.body.getTextArea().setText(this.nodeSettings.body());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

