/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.autocompleteingredientsearch;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class AutocompleteIngredientSearchNodeSettings {
    private static final String QUERY_KEY = "query";
    private static final String QUERY_DEFAULT_VALUE = null;
    private String query = QUERY_DEFAULT_VALUE;
    private static final String QUERY_ENABLED_KEY = "queryEnabled";
    private boolean queryEnabled = false;
    private static final String NUMBER_KEY = "number";
    static final Integer NUMBER_DEFAULT_VALUE = 10;
    static final Integer NUMBER_MINIMUM_VALUE = 1;
    static final Integer NUMBER_MAXIMUM_VALUE = 100;
    private int number = NUMBER_DEFAULT_VALUE;
    private static final String NUMBER_ENABLED_KEY = "numberEnabled";
    private boolean numberEnabled = false;
    private static final String META_INFORMATION_KEY = "metaInformation";
    private static final boolean META_INFORMATION_DEFAULT_VALUE = false;
    private boolean metaInformation = false;
    private static final String META_INFORMATION_ENABLED_KEY = "metaInformationEnabled";
    private boolean metaInformationEnabled = false;
    private static final String INTOLERANCES_KEY = "intolerances";
    private static final String INTOLERANCES_DEFAULT_VALUE = null;
    private String intolerances = INTOLERANCES_DEFAULT_VALUE;
    private static final String INTOLERANCES_ENABLED_KEY = "intolerancesEnabled";
    private boolean intolerancesEnabled = false;
    static final String[] LANGUAGE_VALUES = new String[]{"en", "de"};
    private static final String LANGUAGE_KEY = "language";
    private static final String LANGUAGE_DEFAULT_VALUE = LANGUAGE_VALUES[0];
    private String language = LANGUAGE_DEFAULT_VALUE;
    private static final String LANGUAGE_ENABLED_KEY = "languageEnabled";
    private boolean languageEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    AutocompleteIngredientSearchNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(QUERY_KEY, this.query);
        settings.addBoolean(QUERY_ENABLED_KEY, this.queryEnabled);
        settings.addInt(NUMBER_KEY, this.number);
        settings.addBoolean(NUMBER_ENABLED_KEY, this.numberEnabled);
        settings.addBoolean(META_INFORMATION_KEY, this.metaInformation);
        settings.addBoolean(META_INFORMATION_ENABLED_KEY, this.metaInformationEnabled);
        settings.addString(INTOLERANCES_KEY, this.intolerances);
        settings.addBoolean(INTOLERANCES_ENABLED_KEY, this.intolerancesEnabled);
        settings.addString(LANGUAGE_KEY, this.language);
        settings.addBoolean(LANGUAGE_ENABLED_KEY, this.languageEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.query = settings.getString(QUERY_KEY, QUERY_DEFAULT_VALUE);
        this.queryEnabled = settings.getBoolean(QUERY_ENABLED_KEY, false);
        this.number = settings.getInt(NUMBER_KEY, NUMBER_DEFAULT_VALUE.intValue());
        this.numberEnabled = settings.getBoolean(NUMBER_ENABLED_KEY, false);
        this.metaInformation = settings.getBoolean(META_INFORMATION_KEY, false);
        this.metaInformationEnabled = settings.getBoolean(META_INFORMATION_ENABLED_KEY, false);
        this.intolerances = settings.getString(INTOLERANCES_KEY, INTOLERANCES_DEFAULT_VALUE);
        this.intolerancesEnabled = settings.getBoolean(INTOLERANCES_ENABLED_KEY, false);
        this.language = settings.getString(LANGUAGE_KEY, LANGUAGE_DEFAULT_VALUE);
        this.languageEnabled = settings.getBoolean(LANGUAGE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String query() {
        return this.query;
    }

    void query(String value) {
        this.query = value;
    }

    boolean queryEnabled() {
        return this.queryEnabled;
    }

    void queryEnabled(boolean value) {
        this.queryEnabled = value;
    }

    int number() {
        return this.number;
    }

    void number(int value) {
        this.number = value;
    }

    boolean numberEnabled() {
        return this.numberEnabled;
    }

    void numberEnabled(boolean value) {
        this.numberEnabled = value;
    }

    boolean metaInformation() {
        return this.metaInformation;
    }

    void metaInformation(boolean value) {
        this.metaInformation = value;
    }

    boolean metaInformationEnabled() {
        return this.metaInformationEnabled;
    }

    void metaInformationEnabled(boolean value) {
        this.metaInformationEnabled = value;
    }

    String intolerances() {
        return this.intolerances;
    }

    void intolerances(String value) {
        this.intolerances = value;
    }

    boolean intolerancesEnabled() {
        return this.intolerancesEnabled;
    }

    void intolerancesEnabled(boolean value) {
        this.intolerancesEnabled = value;
    }

    String language() {
        return this.language;
    }

    void language(String value) {
        this.language = value;
    }

    boolean languageEnabled() {
        return this.languageEnabled;
    }

    void languageEnabled(boolean value) {
        this.languageEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

