/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.classifygroceryproduct;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.classifygroceryproduct.ClassifyGroceryProductNodeSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class ClassifyGroceryProductNodeDialog
extends NodeDialogPane {
    private final ClassifyGroceryProductNodeSettings nodeSettings = new ClassifyGroceryProductNodeSettings();
    private JComboBox<String> locale;
    private JCheckBox localeEnabled;
    private RTextScrollPane body;
    private JComboBox<ResponseMapper> resultFormat;

    ClassifyGroceryProductNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Locale:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.localeEnabled = new JCheckBox();
        this.localeEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.localeEnabled.setSelected(!this.localeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.localeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.locale = new JComboBox<String>(ClassifyGroceryProductNodeSettings.LOCALE_VALUES);
        panel.add(this.locale, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Body:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        RSyntaxTextArea textArea1 = new RSyntaxTextArea();
        textArea1.setCodeFoldingEnabled(true);
        textArea1.setSyntaxEditingStyle("text/json");
        textArea1.setAntiAliasingEnabled(true);
        this.body = new RTextScrollPane((RTextArea)textArea1);
        this.body.setPreferredSize(new Dimension(400, 300));
        panel.add((Component)this.body, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(ClassifyGroceryProductNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.locale.setEnabled(this.localeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.locale((String)this.locale.getSelectedItem());
        this.nodeSettings.localeEnabled(this.localeEnabled.isSelected());
        this.nodeSettings.body(this.body.getTextArea().getText());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.locale.setSelectedItem(this.nodeSettings.locale());
        this.localeEnabled.setSelected(this.nodeSettings.localeEnabled());
        this.body.getTextArea().setText(this.nodeSettings.body());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

