/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.generatemealplan;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.generatemealplan.GenerateMealPlanNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class GenerateMealPlanNodeDialog
extends NodeDialogPane {
    private final GenerateMealPlanNodeSettings nodeSettings = new GenerateMealPlanNodeSettings();
    private JTextField timeFrame;
    private JCheckBox timeFrameEnabled;
    private JTextField targetCalories;
    private JCheckBox targetCaloriesEnabled;
    private JTextField diet;
    private JCheckBox dietEnabled;
    private JTextField exclude;
    private JCheckBox excludeEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    GenerateMealPlanNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Time Frame:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.timeFrameEnabled = new JCheckBox();
        this.timeFrameEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.timeFrameEnabled.setSelected(!this.timeFrameEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.timeFrameEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.timeFrame = new JTextField(30);
        panel.add((Component)this.timeFrame, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Target Calories:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.targetCaloriesEnabled = new JCheckBox();
        this.targetCaloriesEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.targetCaloriesEnabled.setSelected(!this.targetCaloriesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.targetCaloriesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.targetCalories = new JTextField(30);
        panel.add((Component)this.targetCalories, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Diet:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.dietEnabled = new JCheckBox();
        this.dietEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.dietEnabled.setSelected(!this.dietEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.dietEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.diet = new JTextField(30);
        panel.add((Component)this.diet, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Exclude:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.excludeEnabled = new JCheckBox();
        this.excludeEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.excludeEnabled.setSelected(!this.excludeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.excludeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.exclude = new JTextField(30);
        panel.add((Component)this.exclude, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(GenerateMealPlanNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.timeFrame.setEnabled(this.timeFrameEnabled.isSelected());
        this.targetCalories.setEnabled(this.targetCaloriesEnabled.isSelected());
        this.diet.setEnabled(this.dietEnabled.isSelected());
        this.exclude.setEnabled(this.excludeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.timeFrame(this.timeFrame.getText());
        this.nodeSettings.timeFrameEnabled(this.timeFrameEnabled.isSelected());
        this.nodeSettings.targetCalories(this.targetCalories.getText());
        this.nodeSettings.targetCaloriesEnabled(this.targetCaloriesEnabled.isSelected());
        this.nodeSettings.diet(this.diet.getText());
        this.nodeSettings.dietEnabled(this.dietEnabled.isSelected());
        this.nodeSettings.exclude(this.exclude.getText());
        this.nodeSettings.excludeEnabled(this.excludeEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.timeFrame.setText(this.nodeSettings.timeFrame());
        this.timeFrameEnabled.setSelected(this.nodeSettings.timeFrameEnabled());
        this.targetCalories.setText(this.nodeSettings.targetCalories());
        this.targetCaloriesEnabled.setSelected(this.nodeSettings.targetCaloriesEnabled());
        this.diet.setText(this.nodeSettings.diet());
        this.dietEnabled.setSelected(this.nodeSettings.dietEnabled());
        this.exclude.setText(this.nodeSettings.exclude());
        this.excludeEnabled.setSelected(this.nodeSettings.excludeEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

