/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getanalyzedrecipeinstructions;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetAnalyzedRecipeInstructionsNodeSettings {
    private static final String ID_KEY = "id";
    static final Integer ID_DEFAULT_VALUE = 0;
    static final Integer ID_MINIMUM_VALUE = null;
    static final Integer ID_MAXIMUM_VALUE = null;
    private int id = ID_DEFAULT_VALUE;
    private static final String STEP_BREAKDOWN_KEY = "stepBreakdown";
    private static final boolean STEP_BREAKDOWN_DEFAULT_VALUE = false;
    private boolean stepBreakdown = false;
    private static final String STEP_BREAKDOWN_ENABLED_KEY = "stepBreakdownEnabled";
    private boolean stepBreakdownEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetAnalyzedRecipeInstructionsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(ID_KEY, this.id);
        settings.addBoolean(STEP_BREAKDOWN_KEY, this.stepBreakdown);
        settings.addBoolean(STEP_BREAKDOWN_ENABLED_KEY, this.stepBreakdownEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getInt(ID_KEY, ID_DEFAULT_VALUE.intValue());
        this.stepBreakdown = settings.getBoolean(STEP_BREAKDOWN_KEY, false);
        this.stepBreakdownEnabled = settings.getBoolean(STEP_BREAKDOWN_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int id() {
        return this.id;
    }

    void id(int value) {
        this.id = value;
    }

    boolean stepBreakdown() {
        return this.stepBreakdown;
    }

    void stepBreakdown(boolean value) {
        this.stepBreakdown = value;
    }

    boolean stepBreakdownEnabled() {
        return this.stepBreakdownEnabled;
    }

    void stepBreakdownEnabled(boolean value) {
        this.stepBreakdownEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

