/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getrandomrecipes;

import com.nodepit.nodes.spoonacular.LabelButton;
import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.operation.getrandomrecipes.GetRandomRecipesNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class GetRandomRecipesNodeDialog
extends NodeDialogPane {
    private final GetRandomRecipesNodeSettings nodeSettings = new GetRandomRecipesNodeSettings();
    private JCheckBox limitLicense;
    private JCheckBox limitLicenseEnabled;
    private JTextField tags;
    private JCheckBox tagsEnabled;
    private JSpinner number;
    private JCheckBox numberEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    GetRandomRecipesNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Limit License:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.limitLicenseEnabled = new JCheckBox();
        this.limitLicenseEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.limitLicenseEnabled.setSelected(!this.limitLicenseEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.limitLicenseEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.limitLicense = new JCheckBox("true");
        panel.add((Component)this.limitLicense, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Tags:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.tagsEnabled = new JCheckBox();
        this.tagsEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.tagsEnabled.setSelected(!this.tagsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.tagsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.tags = new JTextField(30);
        panel.add((Component)this.tags, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Number:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.numberEnabled = new JCheckBox();
        this.numberEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.numberEnabled.setSelected(!this.numberEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.numberEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.number = new JSpinner(new SpinnerNumberModel(GetRandomRecipesNodeSettings.NUMBER_DEFAULT_VALUE, GetRandomRecipesNodeSettings.NUMBER_MINIMUM_VALUE, GetRandomRecipesNodeSettings.NUMBER_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.number, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(GetRandomRecipesNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.limitLicense.setEnabled(this.limitLicenseEnabled.isSelected());
        this.tags.setEnabled(this.tagsEnabled.isSelected());
        this.number.setEnabled(this.numberEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.limitLicense(this.limitLicense.isSelected());
        this.nodeSettings.limitLicenseEnabled(this.limitLicenseEnabled.isSelected());
        this.nodeSettings.tags(this.tags.getText());
        this.nodeSettings.tagsEnabled(this.tagsEnabled.isSelected());
        this.nodeSettings.number((Integer)this.number.getValue());
        this.nodeSettings.numberEnabled(this.numberEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.limitLicense.setSelected(this.nodeSettings.limitLicense());
        this.limitLicenseEnabled.setSelected(this.nodeSettings.limitLicenseEnabled());
        this.tags.setText(this.nodeSettings.tags());
        this.tagsEnabled.setSelected(this.nodeSettings.tagsEnabled());
        this.number.setValue(this.nodeSettings.number());
        this.numberEnabled.setSelected(this.nodeSettings.numberEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

