/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.getwinerecommendation;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetWineRecommendationNodeSettings {
    private static final String WINE_KEY = "wine";
    private static final String WINE_DEFAULT_VALUE = null;
    private String wine = WINE_DEFAULT_VALUE;
    private static final String MAX_PRICE_KEY = "maxPrice";
    private static final String MAX_PRICE_DEFAULT_VALUE = null;
    private String maxPrice = MAX_PRICE_DEFAULT_VALUE;
    private static final String MAX_PRICE_ENABLED_KEY = "maxPriceEnabled";
    private boolean maxPriceEnabled = false;
    private static final String MIN_RATING_KEY = "minRating";
    private static final String MIN_RATING_DEFAULT_VALUE = null;
    private String minRating = MIN_RATING_DEFAULT_VALUE;
    private static final String MIN_RATING_ENABLED_KEY = "minRatingEnabled";
    private boolean minRatingEnabled = false;
    private static final String NUMBER_KEY = "number";
    private static final String NUMBER_DEFAULT_VALUE = "10";
    private String number = "10";
    private static final String NUMBER_ENABLED_KEY = "numberEnabled";
    private boolean numberEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetWineRecommendationNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(WINE_KEY, this.wine);
        settings.addString(MAX_PRICE_KEY, this.maxPrice);
        settings.addBoolean(MAX_PRICE_ENABLED_KEY, this.maxPriceEnabled);
        settings.addString(MIN_RATING_KEY, this.minRating);
        settings.addBoolean(MIN_RATING_ENABLED_KEY, this.minRatingEnabled);
        settings.addString(NUMBER_KEY, this.number);
        settings.addBoolean(NUMBER_ENABLED_KEY, this.numberEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.wine = settings.getString(WINE_KEY, WINE_DEFAULT_VALUE);
        this.maxPrice = settings.getString(MAX_PRICE_KEY, MAX_PRICE_DEFAULT_VALUE);
        this.maxPriceEnabled = settings.getBoolean(MAX_PRICE_ENABLED_KEY, false);
        this.minRating = settings.getString(MIN_RATING_KEY, MIN_RATING_DEFAULT_VALUE);
        this.minRatingEnabled = settings.getBoolean(MIN_RATING_ENABLED_KEY, false);
        this.number = settings.getString(NUMBER_KEY, NUMBER_DEFAULT_VALUE);
        this.numberEnabled = settings.getBoolean(NUMBER_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.wine == null || this.wine.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cWine\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String wine() {
        return this.wine;
    }

    void wine(String value) {
        this.wine = value;
    }

    String maxPrice() {
        return this.maxPrice;
    }

    void maxPrice(String value) {
        this.maxPrice = value;
    }

    boolean maxPriceEnabled() {
        return this.maxPriceEnabled;
    }

    void maxPriceEnabled(boolean value) {
        this.maxPriceEnabled = value;
    }

    String minRating() {
        return this.minRating;
    }

    void minRating(String value) {
        this.minRating = value;
    }

    boolean minRatingEnabled() {
        return this.minRatingEnabled;
    }

    void minRatingEnabled(boolean value) {
        this.minRatingEnabled = value;
    }

    String number() {
        return this.number;
    }

    void number(String value) {
        this.number = value;
    }

    boolean numberEnabled() {
        return this.numberEnabled;
    }

    void numberEnabled(boolean value) {
        this.numberEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

