/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.searchrecipesbyingredients;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchRecipesByIngredientsNodeSettings {
    private static final String INGREDIENTS_KEY = "ingredients";
    private static final String INGREDIENTS_DEFAULT_VALUE = null;
    private String ingredients = INGREDIENTS_DEFAULT_VALUE;
    private static final String INGREDIENTS_ENABLED_KEY = "ingredientsEnabled";
    private boolean ingredientsEnabled = false;
    private static final String NUMBER_KEY = "number";
    static final Integer NUMBER_DEFAULT_VALUE = 10;
    static final Integer NUMBER_MINIMUM_VALUE = 1;
    static final Integer NUMBER_MAXIMUM_VALUE = 100;
    private int number = NUMBER_DEFAULT_VALUE;
    private static final String NUMBER_ENABLED_KEY = "numberEnabled";
    private boolean numberEnabled = false;
    private static final String LIMIT_LICENSE_KEY = "limitLicense";
    private static final boolean LIMIT_LICENSE_DEFAULT_VALUE = true;
    private boolean limitLicense = true;
    private static final String LIMIT_LICENSE_ENABLED_KEY = "limitLicenseEnabled";
    private boolean limitLicenseEnabled = false;
    private static final String RANKING_KEY = "ranking";
    private static final String RANKING_DEFAULT_VALUE = null;
    private String ranking = RANKING_DEFAULT_VALUE;
    private static final String RANKING_ENABLED_KEY = "rankingEnabled";
    private boolean rankingEnabled = false;
    private static final String IGNORE_PANTRY_KEY = "ignorePantry";
    private static final boolean IGNORE_PANTRY_DEFAULT_VALUE = false;
    private boolean ignorePantry = false;
    private static final String IGNORE_PANTRY_ENABLED_KEY = "ignorePantryEnabled";
    private boolean ignorePantryEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchRecipesByIngredientsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(INGREDIENTS_KEY, this.ingredients);
        settings.addBoolean(INGREDIENTS_ENABLED_KEY, this.ingredientsEnabled);
        settings.addInt(NUMBER_KEY, this.number);
        settings.addBoolean(NUMBER_ENABLED_KEY, this.numberEnabled);
        settings.addBoolean(LIMIT_LICENSE_KEY, this.limitLicense);
        settings.addBoolean(LIMIT_LICENSE_ENABLED_KEY, this.limitLicenseEnabled);
        settings.addString(RANKING_KEY, this.ranking);
        settings.addBoolean(RANKING_ENABLED_KEY, this.rankingEnabled);
        settings.addBoolean(IGNORE_PANTRY_KEY, this.ignorePantry);
        settings.addBoolean(IGNORE_PANTRY_ENABLED_KEY, this.ignorePantryEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.ingredients = settings.getString(INGREDIENTS_KEY, INGREDIENTS_DEFAULT_VALUE);
        this.ingredientsEnabled = settings.getBoolean(INGREDIENTS_ENABLED_KEY, false);
        this.number = settings.getInt(NUMBER_KEY, NUMBER_DEFAULT_VALUE.intValue());
        this.numberEnabled = settings.getBoolean(NUMBER_ENABLED_KEY, false);
        this.limitLicense = settings.getBoolean(LIMIT_LICENSE_KEY, true);
        this.limitLicenseEnabled = settings.getBoolean(LIMIT_LICENSE_ENABLED_KEY, false);
        this.ranking = settings.getString(RANKING_KEY, RANKING_DEFAULT_VALUE);
        this.rankingEnabled = settings.getBoolean(RANKING_ENABLED_KEY, false);
        this.ignorePantry = settings.getBoolean(IGNORE_PANTRY_KEY, false);
        this.ignorePantryEnabled = settings.getBoolean(IGNORE_PANTRY_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String ingredients() {
        return this.ingredients;
    }

    void ingredients(String value) {
        this.ingredients = value;
    }

    boolean ingredientsEnabled() {
        return this.ingredientsEnabled;
    }

    void ingredientsEnabled(boolean value) {
        this.ingredientsEnabled = value;
    }

    int number() {
        return this.number;
    }

    void number(int value) {
        this.number = value;
    }

    boolean numberEnabled() {
        return this.numberEnabled;
    }

    void numberEnabled(boolean value) {
        this.numberEnabled = value;
    }

    boolean limitLicense() {
        return this.limitLicense;
    }

    void limitLicense(boolean value) {
        this.limitLicense = value;
    }

    boolean limitLicenseEnabled() {
        return this.limitLicenseEnabled;
    }

    void limitLicenseEnabled(boolean value) {
        this.limitLicenseEnabled = value;
    }

    String ranking() {
        return this.ranking;
    }

    void ranking(String value) {
        this.ranking = value;
    }

    boolean rankingEnabled() {
        return this.rankingEnabled;
    }

    void rankingEnabled(boolean value) {
        this.rankingEnabled = value;
    }

    boolean ignorePantry() {
        return this.ignorePantry;
    }

    void ignorePantry(boolean value) {
        this.ignorePantry = value;
    }

    boolean ignorePantryEnabled() {
        return this.ignorePantryEnabled;
    }

    void ignorePantryEnabled(boolean value) {
        this.ignorePantryEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

