/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.searchrecipesbynutrients;

import com.nodepit.nodes.spoonacular.operation.searchrecipesbynutrients.SearchRecipesByNutrientsNodeSettings;
import com.nodepit.nodes.spoonacular.port.ConfigPortObjectSpec;
import java.io.File;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class SearchRecipesByNutrientsNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(SearchRecipesByNutrientsNodeModel.class);
    private final SearchRecipesByNutrientsNodeSettings nodeSettings = new SearchRecipesByNutrientsNodeSettings();

    protected SearchRecipesByNutrientsNodeModel(PortType[] inPorts, PortType[] outPorts) {
        super(inPorts, outPorts);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        ConfigPortObjectSpec configPortObjectSpec = this.getNrInPorts() == 0 ? ConfigPortObjectSpec.DEFAULT : (ConfigPortObjectSpec)inObjects[0].getSpec();
        String serverUrl = configPortObjectSpec.getUrl();
        String path = "/recipes/findByNutrients";
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(String.valueOf(serverUrl) + path)).newBuilder();
        if (this.nodeSettings.minCarbsEnabled()) {
            urlBuilder.addQueryParameter("minCarbs", String.valueOf(this.nodeSettings.minCarbs()));
        }
        if (this.nodeSettings.maxCarbsEnabled()) {
            urlBuilder.addQueryParameter("maxCarbs", String.valueOf(this.nodeSettings.maxCarbs()));
        }
        if (this.nodeSettings.minProteinEnabled()) {
            urlBuilder.addQueryParameter("minProtein", String.valueOf(this.nodeSettings.minProtein()));
        }
        if (this.nodeSettings.maxProteinEnabled()) {
            urlBuilder.addQueryParameter("maxProtein", String.valueOf(this.nodeSettings.maxProtein()));
        }
        if (this.nodeSettings.minCaloriesEnabled()) {
            urlBuilder.addQueryParameter("minCalories", String.valueOf(this.nodeSettings.minCalories()));
        }
        if (this.nodeSettings.maxCaloriesEnabled()) {
            urlBuilder.addQueryParameter("maxCalories", String.valueOf(this.nodeSettings.maxCalories()));
        }
        if (this.nodeSettings.minFatEnabled()) {
            urlBuilder.addQueryParameter("minFat", String.valueOf(this.nodeSettings.minFat()));
        }
        if (this.nodeSettings.maxFatEnabled()) {
            urlBuilder.addQueryParameter("maxFat", String.valueOf(this.nodeSettings.maxFat()));
        }
        if (this.nodeSettings.minAlcoholEnabled()) {
            urlBuilder.addQueryParameter("minAlcohol", String.valueOf(this.nodeSettings.minAlcohol()));
        }
        if (this.nodeSettings.maxAlcoholEnabled()) {
            urlBuilder.addQueryParameter("maxAlcohol", String.valueOf(this.nodeSettings.maxAlcohol()));
        }
        if (this.nodeSettings.minCaffeineEnabled()) {
            urlBuilder.addQueryParameter("minCaffeine", String.valueOf(this.nodeSettings.minCaffeine()));
        }
        if (this.nodeSettings.maxCaffeineEnabled()) {
            urlBuilder.addQueryParameter("maxCaffeine", String.valueOf(this.nodeSettings.maxCaffeine()));
        }
        if (this.nodeSettings.minCopperEnabled()) {
            urlBuilder.addQueryParameter("minCopper", String.valueOf(this.nodeSettings.minCopper()));
        }
        if (this.nodeSettings.maxCopperEnabled()) {
            urlBuilder.addQueryParameter("maxCopper", String.valueOf(this.nodeSettings.maxCopper()));
        }
        if (this.nodeSettings.minCalciumEnabled()) {
            urlBuilder.addQueryParameter("minCalcium", String.valueOf(this.nodeSettings.minCalcium()));
        }
        if (this.nodeSettings.maxCalciumEnabled()) {
            urlBuilder.addQueryParameter("maxCalcium", String.valueOf(this.nodeSettings.maxCalcium()));
        }
        if (this.nodeSettings.minCholineEnabled()) {
            urlBuilder.addQueryParameter("minCholine", String.valueOf(this.nodeSettings.minCholine()));
        }
        if (this.nodeSettings.maxCholineEnabled()) {
            urlBuilder.addQueryParameter("maxCholine", String.valueOf(this.nodeSettings.maxCholine()));
        }
        if (this.nodeSettings.minCholesterolEnabled()) {
            urlBuilder.addQueryParameter("minCholesterol", String.valueOf(this.nodeSettings.minCholesterol()));
        }
        if (this.nodeSettings.maxCholesterolEnabled()) {
            urlBuilder.addQueryParameter("maxCholesterol", String.valueOf(this.nodeSettings.maxCholesterol()));
        }
        if (this.nodeSettings.minFluorideEnabled()) {
            urlBuilder.addQueryParameter("minFluoride", String.valueOf(this.nodeSettings.minFluoride()));
        }
        if (this.nodeSettings.maxFluorideEnabled()) {
            urlBuilder.addQueryParameter("maxFluoride", String.valueOf(this.nodeSettings.maxFluoride()));
        }
        if (this.nodeSettings.minSaturatedFatEnabled()) {
            urlBuilder.addQueryParameter("minSaturatedFat", String.valueOf(this.nodeSettings.minSaturatedFat()));
        }
        if (this.nodeSettings.maxSaturatedFatEnabled()) {
            urlBuilder.addQueryParameter("maxSaturatedFat", String.valueOf(this.nodeSettings.maxSaturatedFat()));
        }
        if (this.nodeSettings.minVitaminAEnabled()) {
            urlBuilder.addQueryParameter("minVitaminA", String.valueOf(this.nodeSettings.minVitaminA()));
        }
        if (this.nodeSettings.maxVitaminAEnabled()) {
            urlBuilder.addQueryParameter("maxVitaminA", String.valueOf(this.nodeSettings.maxVitaminA()));
        }
        if (this.nodeSettings.minVitaminCEnabled()) {
            urlBuilder.addQueryParameter("minVitaminC", String.valueOf(this.nodeSettings.minVitaminC()));
        }
        if (this.nodeSettings.maxVitaminCEnabled()) {
            urlBuilder.addQueryParameter("maxVitaminC", String.valueOf(this.nodeSettings.maxVitaminC()));
        }
        if (this.nodeSettings.minVitaminDEnabled()) {
            urlBuilder.addQueryParameter("minVitaminD", String.valueOf(this.nodeSettings.minVitaminD()));
        }
        if (this.nodeSettings.maxVitaminDEnabled()) {
            urlBuilder.addQueryParameter("maxVitaminD", String.valueOf(this.nodeSettings.maxVitaminD()));
        }
        if (this.nodeSettings.minVitaminEEnabled()) {
            urlBuilder.addQueryParameter("minVitaminE", String.valueOf(this.nodeSettings.minVitaminE()));
        }
        if (this.nodeSettings.maxVitaminEEnabled()) {
            urlBuilder.addQueryParameter("maxVitaminE", String.valueOf(this.nodeSettings.maxVitaminE()));
        }
        if (this.nodeSettings.minVitaminKEnabled()) {
            urlBuilder.addQueryParameter("minVitaminK", String.valueOf(this.nodeSettings.minVitaminK()));
        }
        if (this.nodeSettings.maxVitaminKEnabled()) {
            urlBuilder.addQueryParameter("maxVitaminK", String.valueOf(this.nodeSettings.maxVitaminK()));
        }
        if (this.nodeSettings.minVitaminB1Enabled()) {
            urlBuilder.addQueryParameter("minVitaminB1", String.valueOf(this.nodeSettings.minVitaminB1()));
        }
        if (this.nodeSettings.maxVitaminB1Enabled()) {
            urlBuilder.addQueryParameter("maxVitaminB1", String.valueOf(this.nodeSettings.maxVitaminB1()));
        }
        if (this.nodeSettings.minVitaminB2Enabled()) {
            urlBuilder.addQueryParameter("minVitaminB2", String.valueOf(this.nodeSettings.minVitaminB2()));
        }
        if (this.nodeSettings.maxVitaminB2Enabled()) {
            urlBuilder.addQueryParameter("maxVitaminB2", String.valueOf(this.nodeSettings.maxVitaminB2()));
        }
        if (this.nodeSettings.minVitaminB5Enabled()) {
            urlBuilder.addQueryParameter("minVitaminB5", String.valueOf(this.nodeSettings.minVitaminB5()));
        }
        if (this.nodeSettings.maxVitaminB5Enabled()) {
            urlBuilder.addQueryParameter("maxVitaminB5", String.valueOf(this.nodeSettings.maxVitaminB5()));
        }
        if (this.nodeSettings.minVitaminB3Enabled()) {
            urlBuilder.addQueryParameter("minVitaminB3", String.valueOf(this.nodeSettings.minVitaminB3()));
        }
        if (this.nodeSettings.maxVitaminB3Enabled()) {
            urlBuilder.addQueryParameter("maxVitaminB3", String.valueOf(this.nodeSettings.maxVitaminB3()));
        }
        if (this.nodeSettings.minVitaminB6Enabled()) {
            urlBuilder.addQueryParameter("minVitaminB6", String.valueOf(this.nodeSettings.minVitaminB6()));
        }
        if (this.nodeSettings.maxVitaminB6Enabled()) {
            urlBuilder.addQueryParameter("maxVitaminB6", String.valueOf(this.nodeSettings.maxVitaminB6()));
        }
        if (this.nodeSettings.minVitaminB12Enabled()) {
            urlBuilder.addQueryParameter("minVitaminB12", String.valueOf(this.nodeSettings.minVitaminB12()));
        }
        if (this.nodeSettings.maxVitaminB12Enabled()) {
            urlBuilder.addQueryParameter("maxVitaminB12", String.valueOf(this.nodeSettings.maxVitaminB12()));
        }
        if (this.nodeSettings.minFiberEnabled()) {
            urlBuilder.addQueryParameter("minFiber", String.valueOf(this.nodeSettings.minFiber()));
        }
        if (this.nodeSettings.maxFiberEnabled()) {
            urlBuilder.addQueryParameter("maxFiber", String.valueOf(this.nodeSettings.maxFiber()));
        }
        if (this.nodeSettings.minFolateEnabled()) {
            urlBuilder.addQueryParameter("minFolate", String.valueOf(this.nodeSettings.minFolate()));
        }
        if (this.nodeSettings.maxFolateEnabled()) {
            urlBuilder.addQueryParameter("maxFolate", String.valueOf(this.nodeSettings.maxFolate()));
        }
        if (this.nodeSettings.minFolicAcidEnabled()) {
            urlBuilder.addQueryParameter("minFolicAcid", String.valueOf(this.nodeSettings.minFolicAcid()));
        }
        if (this.nodeSettings.maxFolicAcidEnabled()) {
            urlBuilder.addQueryParameter("maxFolicAcid", String.valueOf(this.nodeSettings.maxFolicAcid()));
        }
        if (this.nodeSettings.minIodineEnabled()) {
            urlBuilder.addQueryParameter("minIodine", String.valueOf(this.nodeSettings.minIodine()));
        }
        if (this.nodeSettings.maxIodineEnabled()) {
            urlBuilder.addQueryParameter("maxIodine", String.valueOf(this.nodeSettings.maxIodine()));
        }
        if (this.nodeSettings.minIronEnabled()) {
            urlBuilder.addQueryParameter("minIron", String.valueOf(this.nodeSettings.minIron()));
        }
        if (this.nodeSettings.maxIronEnabled()) {
            urlBuilder.addQueryParameter("maxIron", String.valueOf(this.nodeSettings.maxIron()));
        }
        if (this.nodeSettings.minMagnesiumEnabled()) {
            urlBuilder.addQueryParameter("minMagnesium", String.valueOf(this.nodeSettings.minMagnesium()));
        }
        if (this.nodeSettings.maxMagnesiumEnabled()) {
            urlBuilder.addQueryParameter("maxMagnesium", String.valueOf(this.nodeSettings.maxMagnesium()));
        }
        if (this.nodeSettings.minManganeseEnabled()) {
            urlBuilder.addQueryParameter("minManganese", String.valueOf(this.nodeSettings.minManganese()));
        }
        if (this.nodeSettings.maxManganeseEnabled()) {
            urlBuilder.addQueryParameter("maxManganese", String.valueOf(this.nodeSettings.maxManganese()));
        }
        if (this.nodeSettings.minPhosphorusEnabled()) {
            urlBuilder.addQueryParameter("minPhosphorus", String.valueOf(this.nodeSettings.minPhosphorus()));
        }
        if (this.nodeSettings.maxPhosphorusEnabled()) {
            urlBuilder.addQueryParameter("maxPhosphorus", String.valueOf(this.nodeSettings.maxPhosphorus()));
        }
        if (this.nodeSettings.minPotassiumEnabled()) {
            urlBuilder.addQueryParameter("minPotassium", String.valueOf(this.nodeSettings.minPotassium()));
        }
        if (this.nodeSettings.maxPotassiumEnabled()) {
            urlBuilder.addQueryParameter("maxPotassium", String.valueOf(this.nodeSettings.maxPotassium()));
        }
        if (this.nodeSettings.minSeleniumEnabled()) {
            urlBuilder.addQueryParameter("minSelenium", String.valueOf(this.nodeSettings.minSelenium()));
        }
        if (this.nodeSettings.maxSeleniumEnabled()) {
            urlBuilder.addQueryParameter("maxSelenium", String.valueOf(this.nodeSettings.maxSelenium()));
        }
        if (this.nodeSettings.minSodiumEnabled()) {
            urlBuilder.addQueryParameter("minSodium", String.valueOf(this.nodeSettings.minSodium()));
        }
        if (this.nodeSettings.maxSodiumEnabled()) {
            urlBuilder.addQueryParameter("maxSodium", String.valueOf(this.nodeSettings.maxSodium()));
        }
        if (this.nodeSettings.minSugarEnabled()) {
            urlBuilder.addQueryParameter("minSugar", String.valueOf(this.nodeSettings.minSugar()));
        }
        if (this.nodeSettings.maxSugarEnabled()) {
            urlBuilder.addQueryParameter("maxSugar", String.valueOf(this.nodeSettings.maxSugar()));
        }
        if (this.nodeSettings.minZincEnabled()) {
            urlBuilder.addQueryParameter("minZinc", String.valueOf(this.nodeSettings.minZinc()));
        }
        if (this.nodeSettings.maxZincEnabled()) {
            urlBuilder.addQueryParameter("maxZinc", String.valueOf(this.nodeSettings.maxZinc()));
        }
        if (this.nodeSettings.offsetEnabled()) {
            urlBuilder.addQueryParameter("offset", String.valueOf(this.nodeSettings.offset()));
        }
        if (this.nodeSettings.numberEnabled()) {
            urlBuilder.addQueryParameter("number", String.valueOf(this.nodeSettings.number()));
        }
        if (this.nodeSettings.randomEnabled()) {
            urlBuilder.addQueryParameter("random", String.valueOf(this.nodeSettings.random()));
        }
        if (this.nodeSettings.limitLicenseEnabled()) {
            urlBuilder.addQueryParameter("limitLicense", String.valueOf(this.nodeSettings.limitLicense()));
        }
        HttpUrl url = urlBuilder.build();
        RequestBody requestBody = null;
        OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
        configPortObjectSpec.addInterceptors(clientBuilder);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(message -> LOGGER.debug((Object)message));
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        clientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
        OkHttpClient client = clientBuilder.build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        exec.setProgress("Sending request");
        requestBuilder.method("GET", requestBody);
        requestBuilder.header("accept", this.getResponseType());
        Request request = requestBuilder.build();
        Call call = client.newCall(request);
        exec.setProgress("Receiving response");
        Response response = call.execute();
        if (!response.isSuccessful()) {
            String message2 = "Encountered HTTP status " + response.code();
            String bodyString = response.body().string();
            if (bodyString != null && !bodyString.isEmpty()) {
                message2 = String.valueOf(message2) + ": " + bodyString;
            }
            throw new IOException(message2);
        }
        BufferedDataTable responseTable = this.nodeSettings.getResponseMapper().getTable(exec, response, this.getResponseType());
        if (this.getNrInPorts() == 0) {
            return new PortObject[]{responseTable};
        }
        return new PortObject[]{responseTable, inObjects[0]};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        try {
            this.nodeSettings.validateSettings();
        }
        catch (InvalidSettingsException invalidSettingsException) {
            throw new InvalidSettingsException("Missing configuration \u2013 please configure the node.");
        }
        DataTableSpec responseSpec = this.nodeSettings.getResponseMapper().getSpec(this.getResponseType());
        if (this.getNrInPorts() == 0) {
            return new PortObjectSpec[]{responseSpec};
        }
        return new PortObjectSpec[]{responseSpec, inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    private String getResponseType() {
        return "application/json";
    }
}

