/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spoonacular.operation.talktochatbot;

import com.nodepit.nodes.spoonacular.ResponseMapper;
import com.nodepit.nodes.spoonacular.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class TalkToChatbotNodeSettings {
    private static final String TEXT_KEY = "text";
    private static final String TEXT_DEFAULT_VALUE = null;
    private String text = TEXT_DEFAULT_VALUE;
    private static final String CONTEXT_ID_KEY = "contextId";
    private static final String CONTEXT_ID_DEFAULT_VALUE = null;
    private String contextId = CONTEXT_ID_DEFAULT_VALUE;
    private static final String CONTEXT_ID_ENABLED_KEY = "contextIdEnabled";
    private boolean contextIdEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    TalkToChatbotNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(TEXT_KEY, this.text);
        settings.addString(CONTEXT_ID_KEY, this.contextId);
        settings.addBoolean(CONTEXT_ID_ENABLED_KEY, this.contextIdEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.text = settings.getString(TEXT_KEY, TEXT_DEFAULT_VALUE);
        this.contextId = settings.getString(CONTEXT_ID_KEY, CONTEXT_ID_DEFAULT_VALUE);
        this.contextIdEnabled = settings.getBoolean(CONTEXT_ID_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.text == null || this.text.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cText\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String text() {
        return this.text;
    }

    void text(String value) {
        this.text = value;
    }

    String contextId() {
        return this.contextId;
    }

    void contextId(String value) {
        this.contextId = value;
    }

    boolean contextIdEnabled() {
        return this.contextIdEnabled;
    }

    void contextIdEnabled(boolean value) {
        this.contextIdEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

