/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.httpclient.multipart;

import com.github.scribejava.core.httpclient.multipart.ByteArrayBodyPartPayload;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FileByteArrayBodyPartPayload
extends ByteArrayBodyPartPayload {
    public FileByteArrayBodyPartPayload(byte[] payload) {
        this(payload, (String)null);
    }

    public FileByteArrayBodyPartPayload(byte[] payload, int off, int len) {
        this(payload, off, len, (String)null);
    }

    public FileByteArrayBodyPartPayload(byte[] payload, String name) {
        this(payload, name, null);
    }

    public FileByteArrayBodyPartPayload(byte[] payload, int off, int len, String name) {
        this(payload, off, len, name, null);
    }

    public FileByteArrayBodyPartPayload(byte[] payload, String name, String filename) {
        this(null, payload, name, filename);
    }

    public FileByteArrayBodyPartPayload(byte[] payload, int off, int len, String name, String filename) {
        this(null, payload, off, len, name, filename);
    }

    public FileByteArrayBodyPartPayload(String contentType, byte[] payload) {
        this(contentType, payload, null);
    }

    public FileByteArrayBodyPartPayload(String contentType, byte[] payload, int off, int len) {
        this(contentType, payload, off, len, null);
    }

    public FileByteArrayBodyPartPayload(String contentType, byte[] payload, String name) {
        this(contentType, payload, name, null);
    }

    public FileByteArrayBodyPartPayload(String contentType, byte[] payload, int off, int len, String name) {
        this(contentType, payload, off, len, name, null);
    }

    public FileByteArrayBodyPartPayload(String contentType, byte[] payload, String name, String filename) {
        super(payload, FileByteArrayBodyPartPayload.composeHeaders(contentType, name, filename));
    }

    public FileByteArrayBodyPartPayload(String contentType, byte[] payload, int off, int len, String name, String filename) {
        super(payload, off, len, FileByteArrayBodyPartPayload.composeHeaders(contentType, name, filename));
    }

    private static Map<String, String> composeHeaders(String contentType, String name, String filename) {
        String contentDispositionHeader = "form-data";
        if (name != null) {
            contentDispositionHeader = contentDispositionHeader + "; name=\"" + name + '\"';
        }
        if (filename != null) {
            contentDispositionHeader = contentDispositionHeader + "; filename=\"" + filename + '\"';
        }
        if (contentType == null) {
            return Collections.singletonMap("Content-Disposition", contentDispositionHeader);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", contentType);
        headers.put("Content-Disposition", contentDispositionHeader);
        return headers;
    }
}

